/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXLongNumber;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;

public class LongContentCommand
extends TextualContentCommand
implements TeXNumber {
    protected boolean isConstant = false;

    public LongContentCommand(String string, long l) {
        this(string, l, false);
    }

    public LongContentCommand(String string, long l, boolean bl) {
        this(string, "" + l, new TeXLongNumber(l), bl);
    }

    protected LongContentCommand(String string, String string2, TeXLongNumber teXLongNumber) {
        this(string, string2, teXLongNumber, false);
    }

    protected LongContentCommand(String string, String string2, TeXLongNumber teXLongNumber, boolean bl) {
        super(string, string2, teXLongNumber);
        this.isConstant = bl;
    }

    @Override
    public Object clone() {
        return this.isConstant ? this : new LongContentCommand(this.getName(), this.getText(), (TeXLongNumber)this.getNumber().clone());
    }

    @Override
    public TextualContentCommand duplicate(String string) {
        return new LongContentCommand(string, this.getText(), new TeXLongNumber(this.longValue()), false);
    }

    @Override
    public int getValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.getNumber().getValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public void setValue(long l) {
        if (!this.isConstant) {
            this.text = "" + l;
            this.getNumber().setValue(l);
        }
    }

    public TeXLongNumber getNumber() {
        return (TeXLongNumber)this.data;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getNumber().number(teXParser);
    }

    @Override
    public void multiply(int n) {
        if (!this.isConstant) {
            this.getNumber().multiply(n);
            this.text = "" + this.longValue();
        }
    }

    @Override
    public void divide(int n) {
        if (!this.isConstant) {
            this.getNumber().divide(n);
            this.text = "" + this.longValue();
        }
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (this.isConstant) {
            throw new TeXSyntaxException(teXParser, "tex.error.cant_change_const", this.toString(teXParser));
        }
        this.getNumber().advance(teXParser, numerical);
        this.text = "" + this.longValue();
    }
}

