\name{CannyEdgeDetectionImageFilter}
\alias{CannyEdgeDetectionImageFilter}
\title{CannyEdgeDetectionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter is an implementation of a Canny edge detector for scalar-
valued images.
CannyEdgeDetectionImageFilter}
\details{
Based on John Canny's paper "A Computational Approach to Edge
Detection"(IEEE Transactions on Pattern Analysis and Machine
Intelligence, Vol. PAMI-8, No.6, November 1986), there are four major
steps used in the edge-detection scheme: (1) Smooth the input image
with Gaussian filter. (2) Calculate the second directional derivatives
of the smoothed image. (3) Non-Maximum Suppression: the zero-crossings
of 2nd derivative are found, and the sign of third derivative is used
to find the correct extrema. (4) The hysteresis thresholding is
applied to the gradient magnitude (multiplied with zero-crossings) of
the smoothed image to find and link edges.
Inputs and Outputs
The input to this filter should be a scalar, real-valued Itk image of
arbitrary dimension. The output should also be a scalar, real-value
Itk image of the same dimensionality.
Parameters
There are four parameters for this filter that control the sub-filters
used by the algorithm.
Variance and Maximum error are used in the Gaussian smoothing of the
input image. See itkDiscreteGaussianImageFilter for information on
these parameters.
Threshold is the lowest allowed value in the output image. Its data
type is the same as the data type of the output image. Any values
below the Threshold level will be replaced with the OutsideValue
parameter value, whose default is zero.
 TodoEdge-linking will be added when an itk connected component
labeling algorithm is available.
See:
DiscreteGaussianImageFilter
ZeroCrossingImageFilter
ThresholdImageFilter
CannyEdgeDetection for the procedural interface
itk::CannyEdgeDetectionImageFilter for the Doxygen on the original ITK class.
CannyEdgeDetectionImageFilter}
%C++ includes: sitkCannyEdgeDetectionImageFilter.h
\section{Methods}{
\describe{
\item{ CannyEdgeDetectionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetLowerThreshold() const:}{}
\item{std::vector< double > GetMaximumError() const:}{
Set/Get the maximum error of the Gaussian smoothing kernel in each
dimensional direction.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetUpperThreshold() const:}{}
\item{std::vector< double > GetVariance() const:}{
Set/Get the variance of the Gaussian smoothing filter.
}
\item{Self SetLowerThreshold(double LowerThreshold):}{
Set the lower threshold value for detected edges.
}
\item{Self SetMaximumError(double value):}{
Set the values of the MaximumError vector all to value
}
\item{Self SetMaximumError(std::vector< double > MaximumError):}{
Set/Get the MaximumError parameter used by the Gaussian smoothing
filter in this algorithm
}
\item{Self SetUpperThreshold(double UpperThreshold):}{
Set the upper threshold value for detected edges. TODO: Document in
the ITKv4 migration guide that the SetThreshold member function was
removed from the CannyEdgeDetectionImageFilter , and that both UpperThreshold and LowerThreshold need to be set. To
get the same results as with the SetThreshold method change
"myfilter->SetThrehsold" to "myfilter->SetUpperThreshold", and add
"myfilter->SetLowerThreshold(GetUpperThreshold()/2.0)".
}
\item{Self SetVariance(double value):}{
Set the values of the Variance vector all to value
}
\item{Self SetVariance(std::vector< double > Variance):}{
Set/Get the variance of the Gaussian smoothing filter.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CannyEdgeDetectionImageFilter():}{
Destructor
}
}
}
