# Copyright (c) 2024-2026, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_3
import enum
import numpy.dtypes
from _typeshed import Incomplete
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__pyx_unpickle_MatmulAlgo: _cython_3_1_3.cython_function_or_method
__pyx_unpickle_MatmulHeuristicResult: _cython_3_1_3.cython_function_or_method
__test__: dict
check_status: _cython_3_1_3.cython_function_or_method
create: _cython_3_1_3.cython_function_or_method
destroy: _cython_3_1_3.cython_function_or_method
disable_cpu_instructions_set_mask: _cython_3_1_3.cython_function_or_method
get_cudart_version: _cython_3_1_3.cython_function_or_method
get_matmul_algo_cap_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_matmul_algo_config_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_matmul_desc_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_matmul_preference_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_matrix_layout_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_matrix_transform_desc_attribute_dtype: _cython_3_1_3.cython_function_or_method
get_property: _cython_3_1_3.cython_function_or_method
get_status_name: _cython_3_1_3.cython_function_or_method
get_status_string: _cython_3_1_3.cython_function_or_method
get_version: _cython_3_1_3.cython_function_or_method
heuristics_cache_get_capacity: _cython_3_1_3.cython_function_or_method
heuristics_cache_set_capacity: _cython_3_1_3.cython_function_or_method
logger_force_disable: _cython_3_1_3.cython_function_or_method
logger_open_file: _cython_3_1_3.cython_function_or_method
logger_set_level: _cython_3_1_3.cython_function_or_method
logger_set_mask: _cython_3_1_3.cython_function_or_method
matmul: _cython_3_1_3.cython_function_or_method
matmul_algo_cap_get_attribute: _cython_3_1_3.cython_function_or_method
matmul_algo_check: _cython_3_1_3.cython_function_or_method
matmul_algo_config_get_attribute: _cython_3_1_3.cython_function_or_method
matmul_algo_config_set_attribute: _cython_3_1_3.cython_function_or_method
matmul_algo_dtype: numpy.dtypes.VoidDType
matmul_algo_get_heuristic: _cython_3_1_3.cython_function_or_method
matmul_algo_get_ids: _cython_3_1_3.cython_function_or_method
matmul_algo_init: _cython_3_1_3.cython_function_or_method
matmul_desc_create: _cython_3_1_3.cython_function_or_method
matmul_desc_destroy: _cython_3_1_3.cython_function_or_method
matmul_desc_get_attribute: _cython_3_1_3.cython_function_or_method
matmul_desc_set_attribute: _cython_3_1_3.cython_function_or_method
matmul_heuristic_result_dtype: numpy.dtypes.VoidDType
matmul_preference_create: _cython_3_1_3.cython_function_or_method
matmul_preference_destroy: _cython_3_1_3.cython_function_or_method
matmul_preference_get_attribute: _cython_3_1_3.cython_function_or_method
matmul_preference_set_attribute: _cython_3_1_3.cython_function_or_method
matrix_layout_create: _cython_3_1_3.cython_function_or_method
matrix_layout_destroy: _cython_3_1_3.cython_function_or_method
matrix_layout_get_attribute: _cython_3_1_3.cython_function_or_method
matrix_layout_set_attribute: _cython_3_1_3.cython_function_or_method
matrix_transform: _cython_3_1_3.cython_function_or_method
matrix_transform_desc_create: _cython_3_1_3.cython_function_or_method
matrix_transform_desc_destroy: _cython_3_1_3.cython_function_or_method
matrix_transform_desc_get_attribute: _cython_3_1_3.cython_function_or_method
matrix_transform_desc_set_attribute: _cython_3_1_3.cython_function_or_method

class BatchMode(enum.IntEnum):
    """See `cublasLtBatchMode_t`."""
    __new__: ClassVar[Callable] = ...
    POINTER_ARRAY: ClassVar[BatchMode] = ...
    STRIDED: ClassVar[BatchMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class ClusterShape(enum.IntEnum):
    """See `cublasLtClusterShape_t`."""
    __new__: ClassVar[Callable] = ...
    SHAPE_10x1x1: ClassVar[ClusterShape] = ...
    SHAPE_11x1x1: ClassVar[ClusterShape] = ...
    SHAPE_12x1x1: ClassVar[ClusterShape] = ...
    SHAPE_13x1x1: ClassVar[ClusterShape] = ...
    SHAPE_14x1x1: ClassVar[ClusterShape] = ...
    SHAPE_15x1x1: ClassVar[ClusterShape] = ...
    SHAPE_16x1x1: ClassVar[ClusterShape] = ...
    SHAPE_1x10x1: ClassVar[ClusterShape] = ...
    SHAPE_1x11x1: ClassVar[ClusterShape] = ...
    SHAPE_1x12x1: ClassVar[ClusterShape] = ...
    SHAPE_1x13x1: ClassVar[ClusterShape] = ...
    SHAPE_1x14x1: ClassVar[ClusterShape] = ...
    SHAPE_1x15x1: ClassVar[ClusterShape] = ...
    SHAPE_1x16x1: ClassVar[ClusterShape] = ...
    SHAPE_1x1x1: ClassVar[ClusterShape] = ...
    SHAPE_1x2x1: ClassVar[ClusterShape] = ...
    SHAPE_1x3x1: ClassVar[ClusterShape] = ...
    SHAPE_1x4x1: ClassVar[ClusterShape] = ...
    SHAPE_1x5x1: ClassVar[ClusterShape] = ...
    SHAPE_1x6x1: ClassVar[ClusterShape] = ...
    SHAPE_1x7x1: ClassVar[ClusterShape] = ...
    SHAPE_1x8x1: ClassVar[ClusterShape] = ...
    SHAPE_1x9x1: ClassVar[ClusterShape] = ...
    SHAPE_2x1x1: ClassVar[ClusterShape] = ...
    SHAPE_2x2x1: ClassVar[ClusterShape] = ...
    SHAPE_2x3x1: ClassVar[ClusterShape] = ...
    SHAPE_2x4x1: ClassVar[ClusterShape] = ...
    SHAPE_2x5x1: ClassVar[ClusterShape] = ...
    SHAPE_2x6x1: ClassVar[ClusterShape] = ...
    SHAPE_2x7x1: ClassVar[ClusterShape] = ...
    SHAPE_2x8x1: ClassVar[ClusterShape] = ...
    SHAPE_3x1x1: ClassVar[ClusterShape] = ...
    SHAPE_3x2x1: ClassVar[ClusterShape] = ...
    SHAPE_3x3x1: ClassVar[ClusterShape] = ...
    SHAPE_3x4x1: ClassVar[ClusterShape] = ...
    SHAPE_3x5x1: ClassVar[ClusterShape] = ...
    SHAPE_4x1x1: ClassVar[ClusterShape] = ...
    SHAPE_4x2x1: ClassVar[ClusterShape] = ...
    SHAPE_4x3x1: ClassVar[ClusterShape] = ...
    SHAPE_4x4x1: ClassVar[ClusterShape] = ...
    SHAPE_5x1x1: ClassVar[ClusterShape] = ...
    SHAPE_5x2x1: ClassVar[ClusterShape] = ...
    SHAPE_5x3x1: ClassVar[ClusterShape] = ...
    SHAPE_6x1x1: ClassVar[ClusterShape] = ...
    SHAPE_6x2x1: ClassVar[ClusterShape] = ...
    SHAPE_7x1x1: ClassVar[ClusterShape] = ...
    SHAPE_7x2x1: ClassVar[ClusterShape] = ...
    SHAPE_8x1x1: ClassVar[ClusterShape] = ...
    SHAPE_8x2x1: ClassVar[ClusterShape] = ...
    SHAPE_9x1x1: ClassVar[ClusterShape] = ...
    SHAPE_AUTO: ClassVar[ClusterShape] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Epilogue(enum.IntEnum):
    """See `cublasLtEpilogue_t`."""
    __new__: ClassVar[Callable] = ...
    BGRADA: ClassVar[Epilogue] = ...
    BGRADB: ClassVar[Epilogue] = ...
    BIAS: ClassVar[Epilogue] = ...
    DEFAULT: ClassVar[Epilogue] = ...
    DGELU: ClassVar[Epilogue] = ...
    DGELU_BGRAD: ClassVar[Epilogue] = ...
    DRELU: ClassVar[Epilogue] = ...
    DRELU_BGRAD: ClassVar[Epilogue] = ...
    GELU: ClassVar[Epilogue] = ...
    GELU_AUX: ClassVar[Epilogue] = ...
    GELU_AUX_BIAS: ClassVar[Epilogue] = ...
    GELU_BIAS: ClassVar[Epilogue] = ...
    RELU: ClassVar[Epilogue] = ...
    RELU_AUX: ClassVar[Epilogue] = ...
    RELU_AUX_BIAS: ClassVar[Epilogue] = ...
    RELU_BIAS: ClassVar[Epilogue] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulAlgo:
    """MatmulAlgo(size=1)

    Empty-initialize an array of `cublasLtMatmulAlgo_t`.

    The resulting object is of length `size` and of dtype `matmul_algo_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `cublasLtMatmulAlgo_t`"""
    _data: Incomplete
    data_: Incomplete
    ptr: Incomplete
    def __init__(self, size=...) -> Any:
        """Initialize self.  See help(type(self)) for accurate signature."""
    @staticmethod
    def from_data(data) -> Any:
        """MatmulAlgo.from_data(data)

        Create an MatmulAlgo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `matmul_algo_dtype` holding the data."""
    @staticmethod
    def from_ptr(intptr_tptr, size_tsize=..., boolreadonly=...) -> Any:
        """MatmulAlgo.from_ptr(intptr_t ptr, size_t size=1, bool readonly=False)

        Create an MatmulAlgo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`."""
    def __delitem__(self, other) -> None:
        """Delete self[key]."""
    def __eq__(self, other: object) -> bool:
        """Return self==value."""
    def __ge__(self, other: object) -> bool:
        """Return self>=value."""
    def __getitem__(self, index):
        """Return self[key]."""
    def __gt__(self, other: object) -> bool:
        """Return self>value."""
    def __int__(self) -> int:
        """int(self)"""
    def __le__(self, other: object) -> bool:
        """Return self<=value."""
    def __len__(self) -> int:
        """Return len(self)."""
    def __lt__(self, other: object) -> bool:
        """Return self<value."""
    def __ne__(self, other: object) -> bool:
        """Return self!=value."""
    def __reduce__(self):
        """MatmulAlgo.__reduce_cython__(self)"""
    def __reduce_cython__(self) -> Any:
        """MatmulAlgo.__reduce_cython__(self)"""
    def __setitem__(self, index, object) -> None:
        """Set self[key] to value."""
    def __setstate_cython__(self, __pyx_state) -> Any:
        """MatmulAlgo.__setstate_cython__(self, __pyx_state)"""

class MatmulAlgoCapAttribute(enum.IntEnum):
    """See `cublasLtMatmulAlgoCapAttributes_t`."""
    __new__: ClassVar[Callable] = ...
    ATOMIC_SYNC: ClassVar[MatmulAlgoCapAttribute] = ...
    CTA_SWIZZLING_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    CUSTOM_MEMORY_ORDER: ClassVar[MatmulAlgoCapAttribute] = ...
    CUSTOM_OPTION_MAX: ClassVar[MatmulAlgoCapAttribute] = ...
    EPILOGUE_MASK: ClassVar[MatmulAlgoCapAttribute] = ...
    FLOATING_POINT_EMULATION_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    GAUSSIAN_IMPL: ClassVar[MatmulAlgoCapAttribute] = ...
    LD_NEGATIVE: ClassVar[MatmulAlgoCapAttribute] = ...
    MATHMODE_IMPL: ClassVar[MatmulAlgoCapAttribute] = ...
    MIN_ALIGNMENT_A_BYTES: ClassVar[MatmulAlgoCapAttribute] = ...
    MIN_ALIGNMENT_B_BYTES: ClassVar[MatmulAlgoCapAttribute] = ...
    MIN_ALIGNMENT_C_BYTES: ClassVar[MatmulAlgoCapAttribute] = ...
    MIN_ALIGNMENT_D_BYTES: ClassVar[MatmulAlgoCapAttribute] = ...
    NUMERICAL_IMPL_FLAGS: ClassVar[MatmulAlgoCapAttribute] = ...
    OUT_OF_PLACE_RESULT_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    POINTER_ARRAY_BATCH_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    POINTER_MODE_MASK: ClassVar[MatmulAlgoCapAttribute] = ...
    REDUCTION_SCHEME_MASK: ClassVar[MatmulAlgoCapAttribute] = ...
    SPLITK_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    STAGES_IDS: ClassVar[MatmulAlgoCapAttribute] = ...
    STRIDED_BATCH_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    TILE_IDS: ClassVar[MatmulAlgoCapAttribute] = ...
    UPLO_SUPPORT: ClassVar[MatmulAlgoCapAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulAlgoConfigAttribute(enum.IntEnum):
    """See `cublasLtMatmulAlgoConfigAttributes_t`."""
    __new__: ClassVar[Callable] = ...
    CLUSTER_SHAPE_ID: ClassVar[MatmulAlgoConfigAttribute] = ...
    CTA_SWIZZLING: ClassVar[MatmulAlgoConfigAttribute] = ...
    CUSTOM_OPTION: ClassVar[MatmulAlgoConfigAttribute] = ...
    ID: ClassVar[MatmulAlgoConfigAttribute] = ...
    INNER_SHAPE_ID: ClassVar[MatmulAlgoConfigAttribute] = ...
    REDUCTION_SCHEME: ClassVar[MatmulAlgoConfigAttribute] = ...
    SPLITK_NUM: ClassVar[MatmulAlgoConfigAttribute] = ...
    STAGES_ID: ClassVar[MatmulAlgoConfigAttribute] = ...
    TILE_ID: ClassVar[MatmulAlgoConfigAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulDescAttribute(enum.IntEnum):
    """See `cublasLtMatmulDescAttributes_t`."""
    __new__: ClassVar[Callable] = ...
    ALPHA_VECTOR_BATCH_STRIDE: ClassVar[MatmulDescAttribute] = ...
    AMAX_D_POINTER: ClassVar[MatmulDescAttribute] = ...
    ATOMIC_SYNC_IN_COUNTERS_POINTER: ClassVar[MatmulDescAttribute] = ...
    ATOMIC_SYNC_NUM_CHUNKS_D_COLS: ClassVar[MatmulDescAttribute] = ...
    ATOMIC_SYNC_NUM_CHUNKS_D_ROWS: ClassVar[MatmulDescAttribute] = ...
    ATOMIC_SYNC_OUT_COUNTERS_POINTER: ClassVar[MatmulDescAttribute] = ...
    A_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    A_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    BIAS_BATCH_STRIDE: ClassVar[MatmulDescAttribute] = ...
    BIAS_DATA_TYPE: ClassVar[MatmulDescAttribute] = ...
    BIAS_POINTER: ClassVar[MatmulDescAttribute] = ...
    B_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    B_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    COMPUTE_TYPE: ClassVar[MatmulDescAttribute] = ...
    C_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    C_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    D_OUT_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    D_OUT_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    D_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    D_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_AMAX_POINTER: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_BATCH_STRIDE: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_DATA_TYPE: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_LD: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_POINTER: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_SCALE_MODE: ClassVar[MatmulDescAttribute] = ...
    EPILOGUE_AUX_SCALE_POINTER: ClassVar[MatmulDescAttribute] = ...
    FAST_ACCUM: ClassVar[MatmulDescAttribute] = ...
    FILL_MODE: ClassVar[MatmulDescAttribute] = ...
    POINTER_MODE: ClassVar[MatmulDescAttribute] = ...
    SCALE_TYPE: ClassVar[MatmulDescAttribute] = ...
    SM_COUNT_TARGET: ClassVar[MatmulDescAttribute] = ...
    TRANSA: ClassVar[MatmulDescAttribute] = ...
    TRANSB: ClassVar[MatmulDescAttribute] = ...
    TRANSC: ClassVar[MatmulDescAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulHeuristicResult:
    """MatmulHeuristicResult(size=1)

    Empty-initialize an array of `cublasLtMatmulHeuristicResult_t`.

    The resulting object is of length `size` and of dtype `matmul_heuristic_result_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `cublasLtMatmulHeuristicResult_t`"""
    _data: Incomplete
    algo: matmul_algo_dtype
    ptr: Incomplete
    state: Incomplete
    waves_count: Incomplete
    workspace_size: Incomplete
    def __init__(self, size=...) -> Any:
        """Initialize self.  See help(type(self)) for accurate signature."""
    @staticmethod
    def from_data(data) -> Any:
        """MatmulHeuristicResult.from_data(data)

        Create an MatmulHeuristicResult instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `matmul_heuristic_result_dtype` holding the data."""
    @staticmethod
    def from_ptr(intptr_tptr, size_tsize=..., boolreadonly=...) -> Any:
        """MatmulHeuristicResult.from_ptr(intptr_t ptr, size_t size=1, bool readonly=False)

        Create an MatmulHeuristicResult instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`."""
    def __delitem__(self, other) -> None:
        """Delete self[key]."""
    def __eq__(self, other: object) -> bool:
        """Return self==value."""
    def __ge__(self, other: object) -> bool:
        """Return self>=value."""
    def __getitem__(self, index):
        """Return self[key]."""
    def __gt__(self, other: object) -> bool:
        """Return self>value."""
    def __int__(self) -> int:
        """int(self)"""
    def __le__(self, other: object) -> bool:
        """Return self<=value."""
    def __len__(self) -> int:
        """Return len(self)."""
    def __lt__(self, other: object) -> bool:
        """Return self<value."""
    def __ne__(self, other: object) -> bool:
        """Return self!=value."""
    def __reduce__(self):
        """MatmulHeuristicResult.__reduce_cython__(self)"""
    def __reduce_cython__(self) -> Any:
        """MatmulHeuristicResult.__reduce_cython__(self)"""
    def __setitem__(self, index, object) -> None:
        """Set self[key] to value."""
    def __setstate_cython__(self, __pyx_state) -> Any:
        """MatmulHeuristicResult.__setstate_cython__(self, __pyx_state)"""

class MatmulInnerShape(enum.IntEnum):
    """See `cublasLtMatmulInnerShape_t`."""
    __new__: ClassVar[Callable] = ...
    MMA16816: ClassVar[MatmulInnerShape] = ...
    MMA1684: ClassVar[MatmulInnerShape] = ...
    MMA1688: ClassVar[MatmulInnerShape] = ...
    MMA884: ClassVar[MatmulInnerShape] = ...
    UNDEFINED: ClassVar[MatmulInnerShape] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulMatrixScale(enum.IntEnum):
    """See `cublasLtMatmulMatrixScale_t`."""
    __new__: ClassVar[Callable] = ...
    BLK128x128_32F: ClassVar[MatmulMatrixScale] = ...
    OUTER_VEC_32F: ClassVar[MatmulMatrixScale] = ...
    SCALAR_32F: ClassVar[MatmulMatrixScale] = ...
    VEC128_32F: ClassVar[MatmulMatrixScale] = ...
    VEC16_UE4M3: ClassVar[MatmulMatrixScale] = ...
    VEC32_UE8M0: ClassVar[MatmulMatrixScale] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulPreferenceAttribute(enum.IntEnum):
    """See `cublasLtMatmulPreferenceAttributes_t`."""
    __new__: ClassVar[Callable] = ...
    EPILOGUE_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    GAUSSIAN_MODE_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    IMPL_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    MATH_MODE_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    MAX_WAVES_COUNT: ClassVar[MatmulPreferenceAttribute] = ...
    MAX_WORKSPACE_BYTES: ClassVar[MatmulPreferenceAttribute] = ...
    MIN_ALIGNMENT_A_BYTES: ClassVar[MatmulPreferenceAttribute] = ...
    MIN_ALIGNMENT_B_BYTES: ClassVar[MatmulPreferenceAttribute] = ...
    MIN_ALIGNMENT_C_BYTES: ClassVar[MatmulPreferenceAttribute] = ...
    MIN_ALIGNMENT_D_BYTES: ClassVar[MatmulPreferenceAttribute] = ...
    POINTER_MODE_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    REDUCTION_SCHEME_MASK: ClassVar[MatmulPreferenceAttribute] = ...
    SEARCH_MODE: ClassVar[MatmulPreferenceAttribute] = ...
    SM_COUNT_TARGET: ClassVar[MatmulPreferenceAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulSearch(enum.IntEnum):
    """See `cublasLtMatmulSearch_t`."""
    __new__: ClassVar[Callable] = ...
    BEST_FIT: ClassVar[MatmulSearch] = ...
    LIMITED_BY_ALGO_ID: ClassVar[MatmulSearch] = ...
    RESERVED_02: ClassVar[MatmulSearch] = ...
    RESERVED_03: ClassVar[MatmulSearch] = ...
    RESERVED_04: ClassVar[MatmulSearch] = ...
    RESERVED_05: ClassVar[MatmulSearch] = ...
    RESERVED_06: ClassVar[MatmulSearch] = ...
    RESERVED_07: ClassVar[MatmulSearch] = ...
    RESERVED_08: ClassVar[MatmulSearch] = ...
    RESERVED_09: ClassVar[MatmulSearch] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulStages(enum.IntEnum):
    """See `cublasLtMatmulStages_t`."""
    __new__: ClassVar[Callable] = ...
    STAGES_128x1: ClassVar[MatmulStages] = ...
    STAGES_128x2: ClassVar[MatmulStages] = ...
    STAGES_128x3: ClassVar[MatmulStages] = ...
    STAGES_128x4: ClassVar[MatmulStages] = ...
    STAGES_128x5: ClassVar[MatmulStages] = ...
    STAGES_128x6: ClassVar[MatmulStages] = ...
    STAGES_128xAUTO: ClassVar[MatmulStages] = ...
    STAGES_16x1: ClassVar[MatmulStages] = ...
    STAGES_16x10: ClassVar[MatmulStages] = ...
    STAGES_16x2: ClassVar[MatmulStages] = ...
    STAGES_16x3: ClassVar[MatmulStages] = ...
    STAGES_16x4: ClassVar[MatmulStages] = ...
    STAGES_16x5: ClassVar[MatmulStages] = ...
    STAGES_16x6: ClassVar[MatmulStages] = ...
    STAGES_16x80: ClassVar[MatmulStages] = ...
    STAGES_16xAUTO: ClassVar[MatmulStages] = ...
    STAGES_256xAUTO: ClassVar[MatmulStages] = ...
    STAGES_32x1: ClassVar[MatmulStages] = ...
    STAGES_32x10: ClassVar[MatmulStages] = ...
    STAGES_32x2: ClassVar[MatmulStages] = ...
    STAGES_32x3: ClassVar[MatmulStages] = ...
    STAGES_32x4: ClassVar[MatmulStages] = ...
    STAGES_32x5: ClassVar[MatmulStages] = ...
    STAGES_32x6: ClassVar[MatmulStages] = ...
    STAGES_32xAUTO: ClassVar[MatmulStages] = ...
    STAGES_64x1: ClassVar[MatmulStages] = ...
    STAGES_64x2: ClassVar[MatmulStages] = ...
    STAGES_64x3: ClassVar[MatmulStages] = ...
    STAGES_64x4: ClassVar[MatmulStages] = ...
    STAGES_64x5: ClassVar[MatmulStages] = ...
    STAGES_64x6: ClassVar[MatmulStages] = ...
    STAGES_64x80: ClassVar[MatmulStages] = ...
    STAGES_64xAUTO: ClassVar[MatmulStages] = ...
    STAGES_8x3: ClassVar[MatmulStages] = ...
    STAGES_8x4: ClassVar[MatmulStages] = ...
    STAGES_8x5: ClassVar[MatmulStages] = ...
    STAGES_8xAUTO: ClassVar[MatmulStages] = ...
    STAGES_UNDEFINED: ClassVar[MatmulStages] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatmulTile(enum.IntEnum):
    """See `cublasLtMatmulTile_t`."""
    __new__: ClassVar[Callable] = ...
    TILE_104x128: ClassVar[MatmulTile] = ...
    TILE_104x192: ClassVar[MatmulTile] = ...
    TILE_104x256: ClassVar[MatmulTile] = ...
    TILE_104x320: ClassVar[MatmulTile] = ...
    TILE_104x384: ClassVar[MatmulTile] = ...
    TILE_104x448: ClassVar[MatmulTile] = ...
    TILE_104x64: ClassVar[MatmulTile] = ...
    TILE_112x128: ClassVar[MatmulTile] = ...
    TILE_112x192: ClassVar[MatmulTile] = ...
    TILE_112x256: ClassVar[MatmulTile] = ...
    TILE_112x320: ClassVar[MatmulTile] = ...
    TILE_112x384: ClassVar[MatmulTile] = ...
    TILE_112x64: ClassVar[MatmulTile] = ...
    TILE_120x128: ClassVar[MatmulTile] = ...
    TILE_120x192: ClassVar[MatmulTile] = ...
    TILE_120x256: ClassVar[MatmulTile] = ...
    TILE_120x320: ClassVar[MatmulTile] = ...
    TILE_120x384: ClassVar[MatmulTile] = ...
    TILE_120x64: ClassVar[MatmulTile] = ...
    TILE_128x104: ClassVar[MatmulTile] = ...
    TILE_128x112: ClassVar[MatmulTile] = ...
    TILE_128x120: ClassVar[MatmulTile] = ...
    TILE_128x128: ClassVar[MatmulTile] = ...
    TILE_128x136: ClassVar[MatmulTile] = ...
    TILE_128x144: ClassVar[MatmulTile] = ...
    TILE_128x152: ClassVar[MatmulTile] = ...
    TILE_128x16: ClassVar[MatmulTile] = ...
    TILE_128x160: ClassVar[MatmulTile] = ...
    TILE_128x168: ClassVar[MatmulTile] = ...
    TILE_128x176: ClassVar[MatmulTile] = ...
    TILE_128x184: ClassVar[MatmulTile] = ...
    TILE_128x192: ClassVar[MatmulTile] = ...
    TILE_128x200: ClassVar[MatmulTile] = ...
    TILE_128x208: ClassVar[MatmulTile] = ...
    TILE_128x216: ClassVar[MatmulTile] = ...
    TILE_128x224: ClassVar[MatmulTile] = ...
    TILE_128x232: ClassVar[MatmulTile] = ...
    TILE_128x24: ClassVar[MatmulTile] = ...
    TILE_128x240: ClassVar[MatmulTile] = ...
    TILE_128x248: ClassVar[MatmulTile] = ...
    TILE_128x256: ClassVar[MatmulTile] = ...
    TILE_128x264: ClassVar[MatmulTile] = ...
    TILE_128x272: ClassVar[MatmulTile] = ...
    TILE_128x280: ClassVar[MatmulTile] = ...
    TILE_128x288: ClassVar[MatmulTile] = ...
    TILE_128x296: ClassVar[MatmulTile] = ...
    TILE_128x304: ClassVar[MatmulTile] = ...
    TILE_128x312: ClassVar[MatmulTile] = ...
    TILE_128x32: ClassVar[MatmulTile] = ...
    TILE_128x320: ClassVar[MatmulTile] = ...
    TILE_128x328: ClassVar[MatmulTile] = ...
    TILE_128x336: ClassVar[MatmulTile] = ...
    TILE_128x344: ClassVar[MatmulTile] = ...
    TILE_128x352: ClassVar[MatmulTile] = ...
    TILE_128x360: ClassVar[MatmulTile] = ...
    TILE_128x368: ClassVar[MatmulTile] = ...
    TILE_128x376: ClassVar[MatmulTile] = ...
    TILE_128x384: ClassVar[MatmulTile] = ...
    TILE_128x392: ClassVar[MatmulTile] = ...
    TILE_128x40: ClassVar[MatmulTile] = ...
    TILE_128x400: ClassVar[MatmulTile] = ...
    TILE_128x408: ClassVar[MatmulTile] = ...
    TILE_128x416: ClassVar[MatmulTile] = ...
    TILE_128x424: ClassVar[MatmulTile] = ...
    TILE_128x432: ClassVar[MatmulTile] = ...
    TILE_128x440: ClassVar[MatmulTile] = ...
    TILE_128x448: ClassVar[MatmulTile] = ...
    TILE_128x456: ClassVar[MatmulTile] = ...
    TILE_128x464: ClassVar[MatmulTile] = ...
    TILE_128x472: ClassVar[MatmulTile] = ...
    TILE_128x48: ClassVar[MatmulTile] = ...
    TILE_128x480: ClassVar[MatmulTile] = ...
    TILE_128x488: ClassVar[MatmulTile] = ...
    TILE_128x496: ClassVar[MatmulTile] = ...
    TILE_128x504: ClassVar[MatmulTile] = ...
    TILE_128x512: ClassVar[MatmulTile] = ...
    TILE_128x56: ClassVar[MatmulTile] = ...
    TILE_128x64: ClassVar[MatmulTile] = ...
    TILE_128x72: ClassVar[MatmulTile] = ...
    TILE_128x8: ClassVar[MatmulTile] = ...
    TILE_128x80: ClassVar[MatmulTile] = ...
    TILE_128x88: ClassVar[MatmulTile] = ...
    TILE_128x96: ClassVar[MatmulTile] = ...
    TILE_136x128: ClassVar[MatmulTile] = ...
    TILE_136x192: ClassVar[MatmulTile] = ...
    TILE_136x256: ClassVar[MatmulTile] = ...
    TILE_136x320: ClassVar[MatmulTile] = ...
    TILE_136x64: ClassVar[MatmulTile] = ...
    TILE_144x128: ClassVar[MatmulTile] = ...
    TILE_144x192: ClassVar[MatmulTile] = ...
    TILE_144x256: ClassVar[MatmulTile] = ...
    TILE_144x320: ClassVar[MatmulTile] = ...
    TILE_144x64: ClassVar[MatmulTile] = ...
    TILE_152x128: ClassVar[MatmulTile] = ...
    TILE_152x192: ClassVar[MatmulTile] = ...
    TILE_152x256: ClassVar[MatmulTile] = ...
    TILE_152x320: ClassVar[MatmulTile] = ...
    TILE_152x64: ClassVar[MatmulTile] = ...
    TILE_160x128: ClassVar[MatmulTile] = ...
    TILE_160x192: ClassVar[MatmulTile] = ...
    TILE_160x256: ClassVar[MatmulTile] = ...
    TILE_160x64: ClassVar[MatmulTile] = ...
    TILE_168x128: ClassVar[MatmulTile] = ...
    TILE_168x192: ClassVar[MatmulTile] = ...
    TILE_168x256: ClassVar[MatmulTile] = ...
    TILE_168x64: ClassVar[MatmulTile] = ...
    TILE_16x128: ClassVar[MatmulTile] = ...
    TILE_16x16: ClassVar[MatmulTile] = ...
    TILE_16x192: ClassVar[MatmulTile] = ...
    TILE_16x256: ClassVar[MatmulTile] = ...
    TILE_16x32: ClassVar[MatmulTile] = ...
    TILE_16x320: ClassVar[MatmulTile] = ...
    TILE_16x384: ClassVar[MatmulTile] = ...
    TILE_16x448: ClassVar[MatmulTile] = ...
    TILE_16x512: ClassVar[MatmulTile] = ...
    TILE_16x576: ClassVar[MatmulTile] = ...
    TILE_16x64: ClassVar[MatmulTile] = ...
    TILE_16x640: ClassVar[MatmulTile] = ...
    TILE_16x704: ClassVar[MatmulTile] = ...
    TILE_16x768: ClassVar[MatmulTile] = ...
    TILE_16x8: ClassVar[MatmulTile] = ...
    TILE_176x128: ClassVar[MatmulTile] = ...
    TILE_176x192: ClassVar[MatmulTile] = ...
    TILE_176x256: ClassVar[MatmulTile] = ...
    TILE_176x64: ClassVar[MatmulTile] = ...
    TILE_184x128: ClassVar[MatmulTile] = ...
    TILE_184x192: ClassVar[MatmulTile] = ...
    TILE_184x256: ClassVar[MatmulTile] = ...
    TILE_184x64: ClassVar[MatmulTile] = ...
    TILE_192x104: ClassVar[MatmulTile] = ...
    TILE_192x112: ClassVar[MatmulTile] = ...
    TILE_192x120: ClassVar[MatmulTile] = ...
    TILE_192x128: ClassVar[MatmulTile] = ...
    TILE_192x136: ClassVar[MatmulTile] = ...
    TILE_192x144: ClassVar[MatmulTile] = ...
    TILE_192x152: ClassVar[MatmulTile] = ...
    TILE_192x16: ClassVar[MatmulTile] = ...
    TILE_192x160: ClassVar[MatmulTile] = ...
    TILE_192x168: ClassVar[MatmulTile] = ...
    TILE_192x176: ClassVar[MatmulTile] = ...
    TILE_192x184: ClassVar[MatmulTile] = ...
    TILE_192x192: ClassVar[MatmulTile] = ...
    TILE_192x200: ClassVar[MatmulTile] = ...
    TILE_192x208: ClassVar[MatmulTile] = ...
    TILE_192x216: ClassVar[MatmulTile] = ...
    TILE_192x224: ClassVar[MatmulTile] = ...
    TILE_192x232: ClassVar[MatmulTile] = ...
    TILE_192x24: ClassVar[MatmulTile] = ...
    TILE_192x240: ClassVar[MatmulTile] = ...
    TILE_192x248: ClassVar[MatmulTile] = ...
    TILE_192x256: ClassVar[MatmulTile] = ...
    TILE_192x264: ClassVar[MatmulTile] = ...
    TILE_192x272: ClassVar[MatmulTile] = ...
    TILE_192x280: ClassVar[MatmulTile] = ...
    TILE_192x288: ClassVar[MatmulTile] = ...
    TILE_192x296: ClassVar[MatmulTile] = ...
    TILE_192x304: ClassVar[MatmulTile] = ...
    TILE_192x312: ClassVar[MatmulTile] = ...
    TILE_192x32: ClassVar[MatmulTile] = ...
    TILE_192x320: ClassVar[MatmulTile] = ...
    TILE_192x328: ClassVar[MatmulTile] = ...
    TILE_192x336: ClassVar[MatmulTile] = ...
    TILE_192x40: ClassVar[MatmulTile] = ...
    TILE_192x48: ClassVar[MatmulTile] = ...
    TILE_192x56: ClassVar[MatmulTile] = ...
    TILE_192x64: ClassVar[MatmulTile] = ...
    TILE_192x72: ClassVar[MatmulTile] = ...
    TILE_192x8: ClassVar[MatmulTile] = ...
    TILE_192x80: ClassVar[MatmulTile] = ...
    TILE_192x88: ClassVar[MatmulTile] = ...
    TILE_192x96: ClassVar[MatmulTile] = ...
    TILE_200x128: ClassVar[MatmulTile] = ...
    TILE_200x192: ClassVar[MatmulTile] = ...
    TILE_200x64: ClassVar[MatmulTile] = ...
    TILE_208x128: ClassVar[MatmulTile] = ...
    TILE_208x192: ClassVar[MatmulTile] = ...
    TILE_208x64: ClassVar[MatmulTile] = ...
    TILE_216x128: ClassVar[MatmulTile] = ...
    TILE_216x192: ClassVar[MatmulTile] = ...
    TILE_216x64: ClassVar[MatmulTile] = ...
    TILE_224x128: ClassVar[MatmulTile] = ...
    TILE_224x192: ClassVar[MatmulTile] = ...
    TILE_224x64: ClassVar[MatmulTile] = ...
    TILE_232x128: ClassVar[MatmulTile] = ...
    TILE_232x192: ClassVar[MatmulTile] = ...
    TILE_232x64: ClassVar[MatmulTile] = ...
    TILE_240x128: ClassVar[MatmulTile] = ...
    TILE_240x192: ClassVar[MatmulTile] = ...
    TILE_240x64: ClassVar[MatmulTile] = ...
    TILE_248x128: ClassVar[MatmulTile] = ...
    TILE_248x192: ClassVar[MatmulTile] = ...
    TILE_248x64: ClassVar[MatmulTile] = ...
    TILE_24x128: ClassVar[MatmulTile] = ...
    TILE_24x192: ClassVar[MatmulTile] = ...
    TILE_24x256: ClassVar[MatmulTile] = ...
    TILE_24x320: ClassVar[MatmulTile] = ...
    TILE_24x384: ClassVar[MatmulTile] = ...
    TILE_24x448: ClassVar[MatmulTile] = ...
    TILE_24x512: ClassVar[MatmulTile] = ...
    TILE_24x576: ClassVar[MatmulTile] = ...
    TILE_24x64: ClassVar[MatmulTile] = ...
    TILE_24x640: ClassVar[MatmulTile] = ...
    TILE_24x704: ClassVar[MatmulTile] = ...
    TILE_24x768: ClassVar[MatmulTile] = ...
    TILE_256x1024: ClassVar[MatmulTile] = ...
    TILE_256x104: ClassVar[MatmulTile] = ...
    TILE_256x112: ClassVar[MatmulTile] = ...
    TILE_256x120: ClassVar[MatmulTile] = ...
    TILE_256x128: ClassVar[MatmulTile] = ...
    TILE_256x136: ClassVar[MatmulTile] = ...
    TILE_256x144: ClassVar[MatmulTile] = ...
    TILE_256x152: ClassVar[MatmulTile] = ...
    TILE_256x16: ClassVar[MatmulTile] = ...
    TILE_256x160: ClassVar[MatmulTile] = ...
    TILE_256x168: ClassVar[MatmulTile] = ...
    TILE_256x176: ClassVar[MatmulTile] = ...
    TILE_256x184: ClassVar[MatmulTile] = ...
    TILE_256x192: ClassVar[MatmulTile] = ...
    TILE_256x200: ClassVar[MatmulTile] = ...
    TILE_256x208: ClassVar[MatmulTile] = ...
    TILE_256x216: ClassVar[MatmulTile] = ...
    TILE_256x224: ClassVar[MatmulTile] = ...
    TILE_256x232: ClassVar[MatmulTile] = ...
    TILE_256x24: ClassVar[MatmulTile] = ...
    TILE_256x240: ClassVar[MatmulTile] = ...
    TILE_256x248: ClassVar[MatmulTile] = ...
    TILE_256x256: ClassVar[MatmulTile] = ...
    TILE_256x32: ClassVar[MatmulTile] = ...
    TILE_256x40: ClassVar[MatmulTile] = ...
    TILE_256x48: ClassVar[MatmulTile] = ...
    TILE_256x512: ClassVar[MatmulTile] = ...
    TILE_256x56: ClassVar[MatmulTile] = ...
    TILE_256x64: ClassVar[MatmulTile] = ...
    TILE_256x72: ClassVar[MatmulTile] = ...
    TILE_256x8: ClassVar[MatmulTile] = ...
    TILE_256x80: ClassVar[MatmulTile] = ...
    TILE_256x88: ClassVar[MatmulTile] = ...
    TILE_256x96: ClassVar[MatmulTile] = ...
    TILE_264x128: ClassVar[MatmulTile] = ...
    TILE_264x64: ClassVar[MatmulTile] = ...
    TILE_272x128: ClassVar[MatmulTile] = ...
    TILE_272x64: ClassVar[MatmulTile] = ...
    TILE_280x128: ClassVar[MatmulTile] = ...
    TILE_280x64: ClassVar[MatmulTile] = ...
    TILE_288x128: ClassVar[MatmulTile] = ...
    TILE_288x64: ClassVar[MatmulTile] = ...
    TILE_296x128: ClassVar[MatmulTile] = ...
    TILE_296x64: ClassVar[MatmulTile] = ...
    TILE_304x128: ClassVar[MatmulTile] = ...
    TILE_304x64: ClassVar[MatmulTile] = ...
    TILE_312x128: ClassVar[MatmulTile] = ...
    TILE_312x64: ClassVar[MatmulTile] = ...
    TILE_320x104: ClassVar[MatmulTile] = ...
    TILE_320x112: ClassVar[MatmulTile] = ...
    TILE_320x120: ClassVar[MatmulTile] = ...
    TILE_320x128: ClassVar[MatmulTile] = ...
    TILE_320x136: ClassVar[MatmulTile] = ...
    TILE_320x144: ClassVar[MatmulTile] = ...
    TILE_320x152: ClassVar[MatmulTile] = ...
    TILE_320x16: ClassVar[MatmulTile] = ...
    TILE_320x160: ClassVar[MatmulTile] = ...
    TILE_320x168: ClassVar[MatmulTile] = ...
    TILE_320x176: ClassVar[MatmulTile] = ...
    TILE_320x184: ClassVar[MatmulTile] = ...
    TILE_320x192: ClassVar[MatmulTile] = ...
    TILE_320x200: ClassVar[MatmulTile] = ...
    TILE_320x24: ClassVar[MatmulTile] = ...
    TILE_320x32: ClassVar[MatmulTile] = ...
    TILE_320x40: ClassVar[MatmulTile] = ...
    TILE_320x48: ClassVar[MatmulTile] = ...
    TILE_320x56: ClassVar[MatmulTile] = ...
    TILE_320x64: ClassVar[MatmulTile] = ...
    TILE_320x72: ClassVar[MatmulTile] = ...
    TILE_320x8: ClassVar[MatmulTile] = ...
    TILE_320x80: ClassVar[MatmulTile] = ...
    TILE_320x88: ClassVar[MatmulTile] = ...
    TILE_320x96: ClassVar[MatmulTile] = ...
    TILE_328x128: ClassVar[MatmulTile] = ...
    TILE_328x64: ClassVar[MatmulTile] = ...
    TILE_32x128: ClassVar[MatmulTile] = ...
    TILE_32x16: ClassVar[MatmulTile] = ...
    TILE_32x192: ClassVar[MatmulTile] = ...
    TILE_32x256: ClassVar[MatmulTile] = ...
    TILE_32x32: ClassVar[MatmulTile] = ...
    TILE_32x320: ClassVar[MatmulTile] = ...
    TILE_32x384: ClassVar[MatmulTile] = ...
    TILE_32x448: ClassVar[MatmulTile] = ...
    TILE_32x512: ClassVar[MatmulTile] = ...
    TILE_32x576: ClassVar[MatmulTile] = ...
    TILE_32x64: ClassVar[MatmulTile] = ...
    TILE_32x640: ClassVar[MatmulTile] = ...
    TILE_32x704: ClassVar[MatmulTile] = ...
    TILE_32x768: ClassVar[MatmulTile] = ...
    TILE_32x8: ClassVar[MatmulTile] = ...
    TILE_336x128: ClassVar[MatmulTile] = ...
    TILE_336x64: ClassVar[MatmulTile] = ...
    TILE_344x128: ClassVar[MatmulTile] = ...
    TILE_344x64: ClassVar[MatmulTile] = ...
    TILE_352x128: ClassVar[MatmulTile] = ...
    TILE_352x64: ClassVar[MatmulTile] = ...
    TILE_360x128: ClassVar[MatmulTile] = ...
    TILE_360x64: ClassVar[MatmulTile] = ...
    TILE_368x128: ClassVar[MatmulTile] = ...
    TILE_368x64: ClassVar[MatmulTile] = ...
    TILE_376x128: ClassVar[MatmulTile] = ...
    TILE_376x64: ClassVar[MatmulTile] = ...
    TILE_384x104: ClassVar[MatmulTile] = ...
    TILE_384x112: ClassVar[MatmulTile] = ...
    TILE_384x120: ClassVar[MatmulTile] = ...
    TILE_384x128: ClassVar[MatmulTile] = ...
    TILE_384x136: ClassVar[MatmulTile] = ...
    TILE_384x144: ClassVar[MatmulTile] = ...
    TILE_384x152: ClassVar[MatmulTile] = ...
    TILE_384x16: ClassVar[MatmulTile] = ...
    TILE_384x160: ClassVar[MatmulTile] = ...
    TILE_384x168: ClassVar[MatmulTile] = ...
    TILE_384x24: ClassVar[MatmulTile] = ...
    TILE_384x32: ClassVar[MatmulTile] = ...
    TILE_384x40: ClassVar[MatmulTile] = ...
    TILE_384x48: ClassVar[MatmulTile] = ...
    TILE_384x56: ClassVar[MatmulTile] = ...
    TILE_384x64: ClassVar[MatmulTile] = ...
    TILE_384x72: ClassVar[MatmulTile] = ...
    TILE_384x8: ClassVar[MatmulTile] = ...
    TILE_384x80: ClassVar[MatmulTile] = ...
    TILE_384x88: ClassVar[MatmulTile] = ...
    TILE_384x96: ClassVar[MatmulTile] = ...
    TILE_392x64: ClassVar[MatmulTile] = ...
    TILE_400x64: ClassVar[MatmulTile] = ...
    TILE_408x64: ClassVar[MatmulTile] = ...
    TILE_40x128: ClassVar[MatmulTile] = ...
    TILE_40x192: ClassVar[MatmulTile] = ...
    TILE_40x256: ClassVar[MatmulTile] = ...
    TILE_40x320: ClassVar[MatmulTile] = ...
    TILE_40x384: ClassVar[MatmulTile] = ...
    TILE_40x448: ClassVar[MatmulTile] = ...
    TILE_40x512: ClassVar[MatmulTile] = ...
    TILE_40x576: ClassVar[MatmulTile] = ...
    TILE_40x64: ClassVar[MatmulTile] = ...
    TILE_40x640: ClassVar[MatmulTile] = ...
    TILE_40x704: ClassVar[MatmulTile] = ...
    TILE_40x768: ClassVar[MatmulTile] = ...
    TILE_416x64: ClassVar[MatmulTile] = ...
    TILE_424x64: ClassVar[MatmulTile] = ...
    TILE_432x64: ClassVar[MatmulTile] = ...
    TILE_440x64: ClassVar[MatmulTile] = ...
    TILE_448x104: ClassVar[MatmulTile] = ...
    TILE_448x112: ClassVar[MatmulTile] = ...
    TILE_448x120: ClassVar[MatmulTile] = ...
    TILE_448x128: ClassVar[MatmulTile] = ...
    TILE_448x136: ClassVar[MatmulTile] = ...
    TILE_448x144: ClassVar[MatmulTile] = ...
    TILE_448x16: ClassVar[MatmulTile] = ...
    TILE_448x24: ClassVar[MatmulTile] = ...
    TILE_448x32: ClassVar[MatmulTile] = ...
    TILE_448x40: ClassVar[MatmulTile] = ...
    TILE_448x48: ClassVar[MatmulTile] = ...
    TILE_448x56: ClassVar[MatmulTile] = ...
    TILE_448x64: ClassVar[MatmulTile] = ...
    TILE_448x72: ClassVar[MatmulTile] = ...
    TILE_448x8: ClassVar[MatmulTile] = ...
    TILE_448x80: ClassVar[MatmulTile] = ...
    TILE_448x88: ClassVar[MatmulTile] = ...
    TILE_448x96: ClassVar[MatmulTile] = ...
    TILE_456x64: ClassVar[MatmulTile] = ...
    TILE_464x64: ClassVar[MatmulTile] = ...
    TILE_472x64: ClassVar[MatmulTile] = ...
    TILE_480x64: ClassVar[MatmulTile] = ...
    TILE_488x64: ClassVar[MatmulTile] = ...
    TILE_48x128: ClassVar[MatmulTile] = ...
    TILE_48x192: ClassVar[MatmulTile] = ...
    TILE_48x256: ClassVar[MatmulTile] = ...
    TILE_48x320: ClassVar[MatmulTile] = ...
    TILE_48x384: ClassVar[MatmulTile] = ...
    TILE_48x448: ClassVar[MatmulTile] = ...
    TILE_48x512: ClassVar[MatmulTile] = ...
    TILE_48x576: ClassVar[MatmulTile] = ...
    TILE_48x64: ClassVar[MatmulTile] = ...
    TILE_48x640: ClassVar[MatmulTile] = ...
    TILE_48x704: ClassVar[MatmulTile] = ...
    TILE_48x768: ClassVar[MatmulTile] = ...
    TILE_496x64: ClassVar[MatmulTile] = ...
    TILE_504x64: ClassVar[MatmulTile] = ...
    TILE_512x1024: ClassVar[MatmulTile] = ...
    TILE_512x104: ClassVar[MatmulTile] = ...
    TILE_512x112: ClassVar[MatmulTile] = ...
    TILE_512x120: ClassVar[MatmulTile] = ...
    TILE_512x128: ClassVar[MatmulTile] = ...
    TILE_512x16: ClassVar[MatmulTile] = ...
    TILE_512x24: ClassVar[MatmulTile] = ...
    TILE_512x32: ClassVar[MatmulTile] = ...
    TILE_512x40: ClassVar[MatmulTile] = ...
    TILE_512x48: ClassVar[MatmulTile] = ...
    TILE_512x512: ClassVar[MatmulTile] = ...
    TILE_512x56: ClassVar[MatmulTile] = ...
    TILE_512x64: ClassVar[MatmulTile] = ...
    TILE_512x72: ClassVar[MatmulTile] = ...
    TILE_512x8: ClassVar[MatmulTile] = ...
    TILE_512x80: ClassVar[MatmulTile] = ...
    TILE_512x88: ClassVar[MatmulTile] = ...
    TILE_512x96: ClassVar[MatmulTile] = ...
    TILE_520x64: ClassVar[MatmulTile] = ...
    TILE_528x64: ClassVar[MatmulTile] = ...
    TILE_536x64: ClassVar[MatmulTile] = ...
    TILE_544x64: ClassVar[MatmulTile] = ...
    TILE_552x64: ClassVar[MatmulTile] = ...
    TILE_560x64: ClassVar[MatmulTile] = ...
    TILE_568x64: ClassVar[MatmulTile] = ...
    TILE_56x128: ClassVar[MatmulTile] = ...
    TILE_56x192: ClassVar[MatmulTile] = ...
    TILE_56x256: ClassVar[MatmulTile] = ...
    TILE_56x320: ClassVar[MatmulTile] = ...
    TILE_56x384: ClassVar[MatmulTile] = ...
    TILE_56x448: ClassVar[MatmulTile] = ...
    TILE_56x512: ClassVar[MatmulTile] = ...
    TILE_56x576: ClassVar[MatmulTile] = ...
    TILE_56x64: ClassVar[MatmulTile] = ...
    TILE_56x640: ClassVar[MatmulTile] = ...
    TILE_56x704: ClassVar[MatmulTile] = ...
    TILE_56x768: ClassVar[MatmulTile] = ...
    TILE_576x104: ClassVar[MatmulTile] = ...
    TILE_576x112: ClassVar[MatmulTile] = ...
    TILE_576x16: ClassVar[MatmulTile] = ...
    TILE_576x24: ClassVar[MatmulTile] = ...
    TILE_576x32: ClassVar[MatmulTile] = ...
    TILE_576x40: ClassVar[MatmulTile] = ...
    TILE_576x48: ClassVar[MatmulTile] = ...
    TILE_576x56: ClassVar[MatmulTile] = ...
    TILE_576x64: ClassVar[MatmulTile] = ...
    TILE_576x72: ClassVar[MatmulTile] = ...
    TILE_576x8: ClassVar[MatmulTile] = ...
    TILE_576x80: ClassVar[MatmulTile] = ...
    TILE_576x88: ClassVar[MatmulTile] = ...
    TILE_576x96: ClassVar[MatmulTile] = ...
    TILE_584x64: ClassVar[MatmulTile] = ...
    TILE_592x64: ClassVar[MatmulTile] = ...
    TILE_600x64: ClassVar[MatmulTile] = ...
    TILE_608x64: ClassVar[MatmulTile] = ...
    TILE_616x64: ClassVar[MatmulTile] = ...
    TILE_624x64: ClassVar[MatmulTile] = ...
    TILE_632x64: ClassVar[MatmulTile] = ...
    TILE_640x16: ClassVar[MatmulTile] = ...
    TILE_640x24: ClassVar[MatmulTile] = ...
    TILE_640x32: ClassVar[MatmulTile] = ...
    TILE_640x40: ClassVar[MatmulTile] = ...
    TILE_640x48: ClassVar[MatmulTile] = ...
    TILE_640x56: ClassVar[MatmulTile] = ...
    TILE_640x64: ClassVar[MatmulTile] = ...
    TILE_640x72: ClassVar[MatmulTile] = ...
    TILE_640x8: ClassVar[MatmulTile] = ...
    TILE_640x80: ClassVar[MatmulTile] = ...
    TILE_640x88: ClassVar[MatmulTile] = ...
    TILE_640x96: ClassVar[MatmulTile] = ...
    TILE_648x64: ClassVar[MatmulTile] = ...
    TILE_64x104: ClassVar[MatmulTile] = ...
    TILE_64x112: ClassVar[MatmulTile] = ...
    TILE_64x120: ClassVar[MatmulTile] = ...
    TILE_64x128: ClassVar[MatmulTile] = ...
    TILE_64x136: ClassVar[MatmulTile] = ...
    TILE_64x144: ClassVar[MatmulTile] = ...
    TILE_64x152: ClassVar[MatmulTile] = ...
    TILE_64x16: ClassVar[MatmulTile] = ...
    TILE_64x160: ClassVar[MatmulTile] = ...
    TILE_64x168: ClassVar[MatmulTile] = ...
    TILE_64x176: ClassVar[MatmulTile] = ...
    TILE_64x184: ClassVar[MatmulTile] = ...
    TILE_64x192: ClassVar[MatmulTile] = ...
    TILE_64x200: ClassVar[MatmulTile] = ...
    TILE_64x208: ClassVar[MatmulTile] = ...
    TILE_64x216: ClassVar[MatmulTile] = ...
    TILE_64x224: ClassVar[MatmulTile] = ...
    TILE_64x232: ClassVar[MatmulTile] = ...
    TILE_64x24: ClassVar[MatmulTile] = ...
    TILE_64x240: ClassVar[MatmulTile] = ...
    TILE_64x248: ClassVar[MatmulTile] = ...
    TILE_64x256: ClassVar[MatmulTile] = ...
    TILE_64x264: ClassVar[MatmulTile] = ...
    TILE_64x272: ClassVar[MatmulTile] = ...
    TILE_64x280: ClassVar[MatmulTile] = ...
    TILE_64x288: ClassVar[MatmulTile] = ...
    TILE_64x296: ClassVar[MatmulTile] = ...
    TILE_64x304: ClassVar[MatmulTile] = ...
    TILE_64x312: ClassVar[MatmulTile] = ...
    TILE_64x32: ClassVar[MatmulTile] = ...
    TILE_64x320: ClassVar[MatmulTile] = ...
    TILE_64x328: ClassVar[MatmulTile] = ...
    TILE_64x336: ClassVar[MatmulTile] = ...
    TILE_64x344: ClassVar[MatmulTile] = ...
    TILE_64x352: ClassVar[MatmulTile] = ...
    TILE_64x360: ClassVar[MatmulTile] = ...
    TILE_64x368: ClassVar[MatmulTile] = ...
    TILE_64x376: ClassVar[MatmulTile] = ...
    TILE_64x384: ClassVar[MatmulTile] = ...
    TILE_64x392: ClassVar[MatmulTile] = ...
    TILE_64x40: ClassVar[MatmulTile] = ...
    TILE_64x400: ClassVar[MatmulTile] = ...
    TILE_64x408: ClassVar[MatmulTile] = ...
    TILE_64x416: ClassVar[MatmulTile] = ...
    TILE_64x424: ClassVar[MatmulTile] = ...
    TILE_64x432: ClassVar[MatmulTile] = ...
    TILE_64x440: ClassVar[MatmulTile] = ...
    TILE_64x448: ClassVar[MatmulTile] = ...
    TILE_64x456: ClassVar[MatmulTile] = ...
    TILE_64x464: ClassVar[MatmulTile] = ...
    TILE_64x472: ClassVar[MatmulTile] = ...
    TILE_64x48: ClassVar[MatmulTile] = ...
    TILE_64x480: ClassVar[MatmulTile] = ...
    TILE_64x488: ClassVar[MatmulTile] = ...
    TILE_64x496: ClassVar[MatmulTile] = ...
    TILE_64x504: ClassVar[MatmulTile] = ...
    TILE_64x512: ClassVar[MatmulTile] = ...
    TILE_64x520: ClassVar[MatmulTile] = ...
    TILE_64x528: ClassVar[MatmulTile] = ...
    TILE_64x536: ClassVar[MatmulTile] = ...
    TILE_64x544: ClassVar[MatmulTile] = ...
    TILE_64x552: ClassVar[MatmulTile] = ...
    TILE_64x56: ClassVar[MatmulTile] = ...
    TILE_64x560: ClassVar[MatmulTile] = ...
    TILE_64x568: ClassVar[MatmulTile] = ...
    TILE_64x576: ClassVar[MatmulTile] = ...
    TILE_64x584: ClassVar[MatmulTile] = ...
    TILE_64x592: ClassVar[MatmulTile] = ...
    TILE_64x600: ClassVar[MatmulTile] = ...
    TILE_64x608: ClassVar[MatmulTile] = ...
    TILE_64x616: ClassVar[MatmulTile] = ...
    TILE_64x624: ClassVar[MatmulTile] = ...
    TILE_64x632: ClassVar[MatmulTile] = ...
    TILE_64x64: ClassVar[MatmulTile] = ...
    TILE_64x640: ClassVar[MatmulTile] = ...
    TILE_64x648: ClassVar[MatmulTile] = ...
    TILE_64x656: ClassVar[MatmulTile] = ...
    TILE_64x664: ClassVar[MatmulTile] = ...
    TILE_64x672: ClassVar[MatmulTile] = ...
    TILE_64x680: ClassVar[MatmulTile] = ...
    TILE_64x688: ClassVar[MatmulTile] = ...
    TILE_64x696: ClassVar[MatmulTile] = ...
    TILE_64x704: ClassVar[MatmulTile] = ...
    TILE_64x712: ClassVar[MatmulTile] = ...
    TILE_64x72: ClassVar[MatmulTile] = ...
    TILE_64x720: ClassVar[MatmulTile] = ...
    TILE_64x728: ClassVar[MatmulTile] = ...
    TILE_64x736: ClassVar[MatmulTile] = ...
    TILE_64x744: ClassVar[MatmulTile] = ...
    TILE_64x752: ClassVar[MatmulTile] = ...
    TILE_64x760: ClassVar[MatmulTile] = ...
    TILE_64x768: ClassVar[MatmulTile] = ...
    TILE_64x8: ClassVar[MatmulTile] = ...
    TILE_64x80: ClassVar[MatmulTile] = ...
    TILE_64x88: ClassVar[MatmulTile] = ...
    TILE_64x96: ClassVar[MatmulTile] = ...
    TILE_656x64: ClassVar[MatmulTile] = ...
    TILE_664x64: ClassVar[MatmulTile] = ...
    TILE_672x64: ClassVar[MatmulTile] = ...
    TILE_680x64: ClassVar[MatmulTile] = ...
    TILE_688x64: ClassVar[MatmulTile] = ...
    TILE_696x64: ClassVar[MatmulTile] = ...
    TILE_704x16: ClassVar[MatmulTile] = ...
    TILE_704x24: ClassVar[MatmulTile] = ...
    TILE_704x32: ClassVar[MatmulTile] = ...
    TILE_704x40: ClassVar[MatmulTile] = ...
    TILE_704x48: ClassVar[MatmulTile] = ...
    TILE_704x56: ClassVar[MatmulTile] = ...
    TILE_704x64: ClassVar[MatmulTile] = ...
    TILE_704x72: ClassVar[MatmulTile] = ...
    TILE_704x8: ClassVar[MatmulTile] = ...
    TILE_704x80: ClassVar[MatmulTile] = ...
    TILE_704x88: ClassVar[MatmulTile] = ...
    TILE_712x64: ClassVar[MatmulTile] = ...
    TILE_720x64: ClassVar[MatmulTile] = ...
    TILE_728x64: ClassVar[MatmulTile] = ...
    TILE_72x128: ClassVar[MatmulTile] = ...
    TILE_72x192: ClassVar[MatmulTile] = ...
    TILE_72x256: ClassVar[MatmulTile] = ...
    TILE_72x320: ClassVar[MatmulTile] = ...
    TILE_72x384: ClassVar[MatmulTile] = ...
    TILE_72x448: ClassVar[MatmulTile] = ...
    TILE_72x512: ClassVar[MatmulTile] = ...
    TILE_72x576: ClassVar[MatmulTile] = ...
    TILE_72x64: ClassVar[MatmulTile] = ...
    TILE_72x640: ClassVar[MatmulTile] = ...
    TILE_736x64: ClassVar[MatmulTile] = ...
    TILE_744x64: ClassVar[MatmulTile] = ...
    TILE_752x64: ClassVar[MatmulTile] = ...
    TILE_760x64: ClassVar[MatmulTile] = ...
    TILE_768x16: ClassVar[MatmulTile] = ...
    TILE_768x24: ClassVar[MatmulTile] = ...
    TILE_768x32: ClassVar[MatmulTile] = ...
    TILE_768x40: ClassVar[MatmulTile] = ...
    TILE_768x48: ClassVar[MatmulTile] = ...
    TILE_768x56: ClassVar[MatmulTile] = ...
    TILE_768x64: ClassVar[MatmulTile] = ...
    TILE_768x72: ClassVar[MatmulTile] = ...
    TILE_768x8: ClassVar[MatmulTile] = ...
    TILE_768x80: ClassVar[MatmulTile] = ...
    TILE_80x128: ClassVar[MatmulTile] = ...
    TILE_80x192: ClassVar[MatmulTile] = ...
    TILE_80x256: ClassVar[MatmulTile] = ...
    TILE_80x320: ClassVar[MatmulTile] = ...
    TILE_80x384: ClassVar[MatmulTile] = ...
    TILE_80x448: ClassVar[MatmulTile] = ...
    TILE_80x512: ClassVar[MatmulTile] = ...
    TILE_80x576: ClassVar[MatmulTile] = ...
    TILE_80x64: ClassVar[MatmulTile] = ...
    TILE_88x128: ClassVar[MatmulTile] = ...
    TILE_88x192: ClassVar[MatmulTile] = ...
    TILE_88x256: ClassVar[MatmulTile] = ...
    TILE_88x320: ClassVar[MatmulTile] = ...
    TILE_88x384: ClassVar[MatmulTile] = ...
    TILE_88x448: ClassVar[MatmulTile] = ...
    TILE_88x512: ClassVar[MatmulTile] = ...
    TILE_88x64: ClassVar[MatmulTile] = ...
    TILE_8x128: ClassVar[MatmulTile] = ...
    TILE_8x16: ClassVar[MatmulTile] = ...
    TILE_8x192: ClassVar[MatmulTile] = ...
    TILE_8x256: ClassVar[MatmulTile] = ...
    TILE_8x32: ClassVar[MatmulTile] = ...
    TILE_8x320: ClassVar[MatmulTile] = ...
    TILE_8x384: ClassVar[MatmulTile] = ...
    TILE_8x448: ClassVar[MatmulTile] = ...
    TILE_8x512: ClassVar[MatmulTile] = ...
    TILE_8x576: ClassVar[MatmulTile] = ...
    TILE_8x64: ClassVar[MatmulTile] = ...
    TILE_8x640: ClassVar[MatmulTile] = ...
    TILE_8x704: ClassVar[MatmulTile] = ...
    TILE_8x768: ClassVar[MatmulTile] = ...
    TILE_8x8: ClassVar[MatmulTile] = ...
    TILE_96x128: ClassVar[MatmulTile] = ...
    TILE_96x192: ClassVar[MatmulTile] = ...
    TILE_96x256: ClassVar[MatmulTile] = ...
    TILE_96x320: ClassVar[MatmulTile] = ...
    TILE_96x384: ClassVar[MatmulTile] = ...
    TILE_96x448: ClassVar[MatmulTile] = ...
    TILE_96x512: ClassVar[MatmulTile] = ...
    TILE_96x64: ClassVar[MatmulTile] = ...
    TILE_UNDEFINED: ClassVar[MatmulTile] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatrixLayoutAttribute(enum.IntEnum):
    """See `cublasLtMatrixLayoutAttribute_t`."""
    __new__: ClassVar[Callable] = ...
    BATCH_COUNT: ClassVar[MatrixLayoutAttribute] = ...
    BATCH_MODE: ClassVar[MatrixLayoutAttribute] = ...
    COLS: ClassVar[MatrixLayoutAttribute] = ...
    LD: ClassVar[MatrixLayoutAttribute] = ...
    ORDER: ClassVar[MatrixLayoutAttribute] = ...
    PLANE_OFFSET: ClassVar[MatrixLayoutAttribute] = ...
    ROWS: ClassVar[MatrixLayoutAttribute] = ...
    STRIDED_BATCH_OFFSET: ClassVar[MatrixLayoutAttribute] = ...
    TYPE: ClassVar[MatrixLayoutAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatrixTransformDescAttribute(enum.IntEnum):
    """See `cublasLtMatrixTransformDescAttributes_t`."""
    __new__: ClassVar[Callable] = ...
    POINTER_MODE: ClassVar[MatrixTransformDescAttribute] = ...
    SCALE_TYPE: ClassVar[MatrixTransformDescAttribute] = ...
    TRANSA: ClassVar[MatrixTransformDescAttribute] = ...
    TRANSB: ClassVar[MatrixTransformDescAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Order(enum.IntEnum):
    """See `cublasLtOrder_t`."""
    __new__: ClassVar[Callable] = ...
    COL: ClassVar[Order] = ...
    COL32: ClassVar[Order] = ...
    COL32_2R_4R4: ClassVar[Order] = ...
    COL4_4R2_8C: ClassVar[Order] = ...
    ROW: ClassVar[Order] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class PointerMode(enum.IntEnum):
    """See `cublasLtPointerMode_t`."""
    __new__: ClassVar[Callable] = ...
    ALPHA_DEVICE_VECTOR_BETA_HOST: ClassVar[PointerMode] = ...
    ALPHA_DEVICE_VECTOR_BETA_ZERO: ClassVar[PointerMode] = ...
    DEVICE: ClassVar[PointerMode] = ...
    DEVICE_VECTOR: ClassVar[PointerMode] = ...
    HOST: ClassVar[PointerMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class PointerModeMask(enum.IntEnum):
    """See `cublasLtPointerModeMask_t`."""
    __new__: ClassVar[Callable] = ...
    ALPHA_DEVICE_VECTOR_BETA_HOST: ClassVar[PointerModeMask] = ...
    ALPHA_DEVICE_VECTOR_BETA_ZERO: ClassVar[PointerModeMask] = ...
    DEVICE: ClassVar[PointerModeMask] = ...
    DEVICE_VECTOR: ClassVar[PointerModeMask] = ...
    HOST: ClassVar[PointerModeMask] = ...
    NO_FILTERING: ClassVar[PointerModeMask] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class ReductionScheme(enum.IntEnum):
    """See `cublasLtReductionScheme_t`."""
    __new__: ClassVar[Callable] = ...
    COMPUTE_TYPE: ClassVar[ReductionScheme] = ...
    INPLACE: ClassVar[ReductionScheme] = ...
    MASK: ClassVar[ReductionScheme] = ...
    NONE: ClassVar[ReductionScheme] = ...
    OUTPUT_TYPE: ClassVar[ReductionScheme] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class cuBLASLtError(Exception):
    def __init__(self, status) -> Any:
        """cuBLASLtError.__init__(self, status)"""
    def __reduce__(self) -> Any:
        """cuBLASLtError.__reduce__(self)"""
