/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.opensearch.index.IndexService;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCache;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCache;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorFieldType;

public class SparseIndexEventListener
implements IndexEventListener {
    @Generated
    private static final Logger log = LogManager.getLogger(SparseIndexEventListener.class);

    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexShard shard : indexService) {
            try {
                MapperService mapperService = shard.mapperService();
                try {
                    SegmentInfos segmentInfos = (SegmentInfos)shard.getSegmentInfosSnapshot().get();
                    for (int i = 0; i < segmentInfos.size(); ++i) {
                        SegmentInfo segmentInfo = segmentInfos.info((int)i).info;
                        for (MappedFieldType fieldType : mapperService.fieldTypes()) {
                            if (!(fieldType instanceof SparseVectorFieldType)) continue;
                            String fieldName = fieldType.name();
                            CacheKey key = new CacheKey(segmentInfo, fieldName);
                            ForwardIndexCache.getInstance().onIndexRemoval(key);
                            ClusteredPostingCache.getInstance().onIndexRemoval(key);
                        }
                    }
                }
                finally {
                    if (mapperService == null) continue;
                    mapperService.close();
                }
            }
            catch (Exception e) {
                log.error("An error occurred during remove index from cache", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Generated
    public SparseIndexEventListener() {
    }
}

