/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/RetryFailedManagedIndexRequest;", "Lorg/opensearch/action/ActionRequest;", "indices", "", "", "startState", "clusterManagerTimeout", "Lorg/opensearch/common/unit/TimeValue;", "indexType", "<init>", "(Ljava/util/List;Ljava/lang/String;Lorg/opensearch/common/unit/TimeValue;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getIndices", "()Ljava/util/List;", "getStartState", "()Ljava/lang/String;", "getClusterManagerTimeout", "()Lorg/opensearch/common/unit/TimeValue;", "getIndexType", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class RetryFailedManagedIndexRequest
extends ActionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> indices;
    @Nullable
    private final String startState;
    @NotNull
    private final TimeValue clusterManagerTimeout;
    @NotNull
    private final String indexType;
    @NotNull
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot retry on more than one index name/pattern when using a custom index type";

    public RetryFailedManagedIndexRequest(@NotNull List<String> indices, @Nullable String startState, @NotNull TimeValue clusterManagerTimeout, @NotNull String indexType) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)clusterManagerTimeout, (String)"clusterManagerTimeout");
        Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
        this.indices = indices;
        this.startState = startState;
        this.clusterManagerTimeout = clusterManagerTimeout;
        this.indexType = indexType;
    }

    @NotNull
    public final List<String> getIndices() {
        return this.indices;
    }

    @Nullable
    public final String getStartState() {
        return this.startState;
    }

    @NotNull
    public final TimeValue getClusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @NotNull
    public final String getIndexType() {
        return this.indexType;
    }

    public RetryFailedManagedIndexRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        String string = sin.readOptionalString();
        TimeValue timeValue = sin.readTimeValue();
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"readTimeValue(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        this(list, string, timeValue, string2);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing indices", validationException);
        } else if (!Intrinsics.areEqual((Object)this.indexType, (Object)"_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indices);
        out.writeOptionalString(this.startState);
        out.writeTimeValue(this.clusterManagerTimeout);
        out.writeString(this.indexType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/RetryFailedManagedIndexRequest$Companion;", "", "<init>", "()V", "MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

