#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semigroupoids
version:              6.0.1
visibility:           public
id:                   semigroupoids-6.0.1-94KNkvJm0CV8wcScT9KnVQ
key:                  semigroupoids-6.0.1-94KNkvJm0CV8wcScT9KnVQ
license:              BSD-2-Clause
copyright:            Copyright (C) 2011-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/semigroupoids
synopsis:             Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.

    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.

    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.

    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.

    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.

    We describe the relationships between the type classes defined in this package
    and those from `base` (and some from `contravariant`) in the diagram below.
    Thick-bordered nodes correspond to type classes defined in this package;
    thin-bordered ones correspond to type classes from elsewhere. Solid edges
    indicate a subclass relationship that actually exists; dashed edges indicate a
    subclass relationship that /should/ exist, but currently doesn'\''t.

    <<https://raw.githubusercontent.com/ekmett/semigroupoids/master/img/classes.svg Relationships among type classes from this package and others>>

    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.

    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.

    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.

category:             Control, Comonads
abi:                  c2539e11f251a9ea85f911d88f32e9ff
exposed:              True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Contravariant.Conclude
    Data.Functor.Contravariant.Decide Data.Functor.Contravariant.Divise
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Categorical Data.Semigroupoid.Dual
    Data.Semigroupoid.Ob Data.Semigroupoid.Static
    Data.Traversable.Instances Semigroupoids.Do

hidden-modules:       Semigroupoids.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/semigroupoids-6.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/semigroupoids-6.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/semigroupoids-6.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semigroupoids
hs-libraries:         HSsemigroupoids-6.0.1-94KNkvJm0CV8wcScT9KnVQ
depends:
    base-4.18.2.1 base-orphans-0.9.3-HILbhTDEXJYIGnbSbNtfR4
    bifunctors-5.6.2-8n7c3k1VnsqINOpTGehIgH
    comonad-5.0.9-JDHp0Y1NkWeEpM43dsFJOY containers-0.6.7
    contravariant-1.5.5-JUOgBPNZkO18h7ix7HMuaW
    distributive-0.6.2.1-JmORqRoeWjIAB5Y4RQ4bwK
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig template-haskell-2.20.0.0
    transformers-0.6.1.0
    transformers-compat-0.7.2-LmnlcpbfHuuAOWEWPuyobH
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS

haddock-interfaces:
    /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock

haddock-html:         /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

