/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.I18nManager;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.RadioButtonGroup;
import tim.prune.gui.colour.ColourChooser;
import tim.prune.gui.colour.ColourPatch;
import tim.prune.gui.colour.ColourerFactory;
import tim.prune.gui.colour.ColourerPreview;
import tim.prune.gui.colour.PatchListener;
import tim.prune.gui.colour.PointColourer;

public class ColourerSelectorPanel
extends JPanel {
    private JComboBox<String> _typeCombo = null;
    private final ColourerFactory.ColourerId[] _typeIds;
    private JPanel _patchPanel = null;
    private ColourPatch[] _startEndPatches = null;
    private JPanel _maxColoursPanel = null;
    private JComboBox<String> _maxColoursCombo = null;
    private JPanel _wideHuesPanel = null;
    private JRadioButton _narrowHueScalingRadio = null;
    private JRadioButton _wideHueScalingRadio = null;
    private JPanel _previewPanel = null;
    private final ColourerPreview _colourerPreview = new ColourerPreview();
    private static final String[] LABEL_KEYS = new String[]{"start", "end"};

    public ColourerSelectorPanel(ColourChooser colourChooser) {
        this._typeIds = new ColourerFactory.ColourerId[]{ColourerFactory.ColourerId.NONE, ColourerFactory.ColourerId.BY_FILE, ColourerFactory.ColourerId.BY_SEGMENT, ColourerFactory.ColourerId.BY_DATE, ColourerFactory.ColourerId.BY_ALTITUDE, ColourerFactory.ColourerId.BY_SPEED, ColourerFactory.ColourerId.BY_VSPEED, ColourerFactory.ColourerId.BY_GRADIENT};
        this.makeGuiComponents(colourChooser);
    }

    private void makeGuiComponents(ColourChooser colourChooser) {
        JPanel jPanel;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.colourer.intro"));
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        String[] stringArray = new String[this._typeIds.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = I18nManager.getText("dialog.colourer.type." + ColourerFactory.getDescriptionKey(this._typeIds[n]));
            ++n;
        }
        this._typeCombo = new JComboBox<String>(stringArray);
        this._typeCombo.setAlignmentX(0.0f);
        this._typeCombo.addActionListener(actionEvent -> this.onColourerTypeChanged());
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.colourer.type")));
        guiGridLayout.add(this._typeCombo);
        jPanel2.setAlignmentX(0.0f);
        this.add(jPanel2);
        this._patchPanel = new JPanel();
        this._patchPanel.setLayout(new GridLayout());
        this._startEndPatches = new ColourPatch[2];
        JPanel jPanel3 = new JPanel();
        ColourPatch colourPatch = new ColourPatch(Color.BLACK);
        colourPatch.setVisible(false);
        jPanel3.add(colourPatch);
        this._patchPanel.add(jPanel3);
        int n2 = 0;
        while (n2 < 2) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(new JLabel(I18nManager.getText("dialog.colourer." + LABEL_KEYS[n2])));
            ColourPatch colourPatch2 = new ColourPatch(Color.BLUE, this::updatePreview);
            colourPatch2.addMouseListener(new PatchListener(colourPatch2, colourChooser));
            jPanel.add(colourPatch2);
            this._startEndPatches[n2] = colourPatch2;
            jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._patchPanel.add(jPanel);
            ++n2;
        }
        jPanel3 = new JPanel();
        colourPatch = new ColourPatch(Color.BLACK);
        colourPatch.setVisible(false);
        jPanel3.add(colourPatch);
        this._patchPanel.add(jPanel3);
        this._patchPanel.setAlignmentX(0.0f);
        this.add(this._patchPanel);
        this._maxColoursPanel = new JPanel();
        guiGridLayout = new GuiGridLayout(this._maxColoursPanel);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.colourer.maxcolours")));
        String[] stringArray2 = new String[]{"2", "3", "5", "10", "15"};
        this._maxColoursCombo = new JComboBox<String>(stringArray2);
        this._maxColoursCombo.addActionListener(actionEvent -> this.updatePreview());
        guiGridLayout.add(this._maxColoursCombo);
        this._maxColoursPanel.setAlignmentX(0.0f);
        this.add(this._maxColoursPanel);
        this._wideHuesPanel = new JPanel();
        guiGridLayout = new GuiGridLayout(this._wideHuesPanel);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.colourer.huesmode")));
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this._narrowHueScalingRadio = new JRadioButton(I18nManager.getText("dialog.colourer.huesmode.narrow"));
        this._wideHueScalingRadio = new JRadioButton(I18nManager.getText("dialog.colourer.huesmode.wide"));
        jPanel.add(this._narrowHueScalingRadio);
        jPanel.add(this._wideHueScalingRadio);
        this._narrowHueScalingRadio.addActionListener(actionEvent -> this.updatePreview());
        this._wideHueScalingRadio.addActionListener(actionEvent -> this.updatePreview());
        new RadioButtonGroup(this._narrowHueScalingRadio, this._wideHueScalingRadio);
        guiGridLayout.add(jPanel);
        this._wideHuesPanel.setAlignmentX(0.0f);
        this.add(this._wideHuesPanel);
        this._previewPanel = new JPanel();
        this._previewPanel.setLayout(new BoxLayout(this._previewPanel, 1));
        this._previewPanel.add(new JLabel("Preview:"));
        this._previewPanel.add(this._colourerPreview);
        this.add(this._previewPanel);
    }

    private void updatePreview() {
        this._colourerPreview.setColourer(this.getSelectedColourer());
    }

    public void init(PointColourer pointColourer, Color color) {
        Color color2 = null;
        Color color3 = null;
        if (pointColourer != null) {
            this.selectColourerType(ColourerFactory.getId(pointColourer));
            color2 = pointColourer.getStartColour();
            color3 = pointColourer.getEndColour();
            this._maxColoursCombo.setSelectedItem("" + pointColourer.getMaxColours());
            this._narrowHueScalingRadio.setSelected(!pointColourer.isWideHueScaling());
            this._wideHueScalingRadio.setSelected(pointColourer.isWideHueScaling());
        } else {
            this._maxColoursCombo.setSelectedIndex(2);
            this._narrowHueScalingRadio.setSelected(true);
        }
        if (color2 == null) {
            color2 = color;
        }
        if (color3 == null) {
            color3 = ColourerSelectorPanel.makeDefaultEndColour(color);
        }
        this._startEndPatches[0].setColour(color2);
        this._startEndPatches[1].setColour(color3);
        this.onColourerTypeChanged();
    }

    private static Color makeDefaultEndColour(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0] + 0.5f, fArray[1], fArray[2]);
    }

    private void onColourerTypeChanged() {
        PointColourer pointColourer = this.getSelectedColourer();
        this._patchPanel.setVisible(pointColourer != null);
        this._maxColoursPanel.setVisible(pointColourer != null && pointColourer.isDiscrete());
        this._wideHuesPanel.setVisible(pointColourer != null);
        this._previewPanel.setVisible(pointColourer != null);
        this.updatePreview();
    }

    public PointColourer getSelectedColourer() {
        ColourerFactory.ColourerId colourerId = this._typeIds[this._typeCombo.getSelectedIndex()];
        Object object = this._maxColoursCombo.getSelectedItem();
        String string = object == null ? "2" : object.toString();
        PointColourer pointColourer = ColourerFactory.createColourer(colourerId, this._startEndPatches[0].getBackground(), this._startEndPatches[1].getBackground(), string, this._wideHueScalingRadio.isSelected());
        return pointColourer;
    }

    private void selectColourerType(ColourerFactory.ColourerId colourerId) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._typeIds.length) {
            if (this._typeIds[n2] == colourerId) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            System.err.println("Id " + (Object)((Object)colourerId) + " not found in _typeIds!");
        } else {
            this._typeCombo.setSelectedIndex(n);
        }
    }
}

