/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedMinProperties
implements Changed {
    private Integer oldValue;
    private Integer newValue;
    private DiffContext context;

    public ChangedMinProperties(Integer oldValue, Integer newValue, DiffContext context) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.context = context;
    }

    public Integer getOldValue() {
        return this.oldValue;
    }

    public Integer getNewValue() {
        return this.newValue;
    }

    @Override
    public DiffResult isChanged() {
        if (this.oldValue == null && this.newValue == null) {
            return DiffResult.NO_CHANGES;
        }
        if (this.oldValue == null) {
            if (BackwardIncompatibleProp.SCHEMA_MIN_PROPERTIES_CHANGED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
            return DiffResult.COMPATIBLE;
        }
        if (this.newValue == null) {
            return DiffResult.COMPATIBLE;
        }
        if (!this.oldValue.equals(this.newValue)) {
            if (BackwardIncompatibleProp.SCHEMA_MIN_PROPERTIES_CHANGED.enabled(this.context, new Object[0]) && this.newValue > this.oldValue) {
                return DiffResult.INCOMPATIBLE;
            }
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.NO_CHANGES;
    }
}

