/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.BinHandlerFactory;

public class BinUtils {
    public static String extractFieldName(Bin node) {
        UnresolvedExpression unresolvedExpression = node.getField();
        if (unresolvedExpression instanceof Field) {
            Field field = (Field)unresolvedExpression;
            return field.getField().toString();
        }
        throw new IllegalArgumentException("Bin field must be a Field expression");
    }

    public static RexNode createBinExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor rexVisitor) {
        BinHandler handler = BinHandlerFactory.getHandler(node);
        return handler.createExpression(node, fieldExpr, context, rexVisitor);
    }
}

