/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.triggercondition.resolvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.alerting.triggercondition.resolvers.TriggerExpression;
import org.opensearch.alerting.triggercondition.resolvers.TriggerExpressionResolver;
import org.opensearch.alerting.triggercondition.tokens.ExpressionToken;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionConstant;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionOperator;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionToken;
import org.opensearch.commons.alerting.model.DocLevelQuery;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0016J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u0012H\u0016J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0015\u001a\u00020\t2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u0012H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionRPNResolver;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionResolver;", "polishNotation", "Ljava/util/ArrayList;", "Lorg/opensearch/alerting/triggercondition/tokens/ExpressionToken;", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/ArrayList;)V", "eqString", "", "getEqString", "()Ljava/lang/String;", "eqString$delegate", "Lkotlin/Lazy;", "toString", "evaluate", "", "queryToDocIds", "", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "resolveQueryExpression", "queryExpString", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTriggerExpressionRPNResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerExpressionRPNResolver.kt\norg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionRPNResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class TriggerExpressionRPNResolver
implements TriggerExpressionResolver {
    @NotNull
    private final ArrayList<ExpressionToken> polishNotation;
    @NotNull
    private final Lazy eqString$delegate;

    public TriggerExpressionRPNResolver(@NotNull ArrayList<ExpressionToken> polishNotation) {
        Intrinsics.checkNotNullParameter(polishNotation, (String)"polishNotation");
        this.polishNotation = polishNotation;
        this.eqString$delegate = LazyKt.lazy(() -> TriggerExpressionRPNResolver.eqString_delegate$lambda$0(this));
    }

    private final String getEqString() {
        Lazy lazy = this.eqString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.getEqString();
    }

    @Override
    @NotNull
    public Set<String> evaluate(@NotNull Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        Intrinsics.checkNotNullParameter(queryToDocIds, (String)"queryToDocIds");
        Stack<Set<String>> tokenStack = new Stack<Set<String>>();
        Set allDocIds = new LinkedHashSet();
        for (Set<String> set : queryToDocIds.values()) {
            allDocIds.addAll((Collection)set);
        }
        Iterator<ExpressionToken> iterator = this.polishNotation.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ExpressionToken expressionToken;
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            ExpressionToken expressionToken2 = expressionToken = (ExpressionToken)object;
            if (expressionToken2 instanceof TriggerExpressionToken) {
                tokenStack.push(this.resolveQueryExpression(((TriggerExpressionToken)expressionToken).getValue(), queryToDocIds));
                continue;
            }
            if (!(expressionToken2 instanceof TriggerExpressionOperator)) continue;
            Set right = (Set)tokenStack.pop();
            TriggerExpression expr = switch (WhenMappings.$EnumSwitchMapping$0[((TriggerExpressionOperator)expressionToken).ordinal()]) {
                case 1 -> {
                    Object v2 = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"pop(...)");
                    Set v3 = (Set)v2;
                    Intrinsics.checkNotNull((Object)right);
                    yield new TriggerExpression.And(v3, right);
                }
                case 2 -> {
                    Object v5 = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(v5, (String)"pop(...)");
                    Set v6 = (Set)v5;
                    Intrinsics.checkNotNull((Object)right);
                    yield new TriggerExpression.Or(v6, right);
                }
                case 3 -> {
                    Intrinsics.checkNotNull((Object)right);
                    yield new TriggerExpression.Not(allDocIds, right);
                }
                default -> throw new IllegalArgumentException("No matching operator.");
            };
            tokenStack.push(expr.resolve());
        }
        Object e = tokenStack.pop();
        Intrinsics.checkNotNullExpressionValue(e, (String)"pop(...)");
        return (Set)e;
    }

    private final Set<String> resolveQueryExpression(String queryExpString, Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        if (!StringsKt.startsWith$default((String)queryExpString, (String)TriggerExpressionConstant.ConstantType.QUERY.getIdent(), (boolean)false, (int)2, null)) {
            return SetsKt.emptySet();
        }
        String token = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)queryExpString, (String)TriggerExpressionConstant.ConstantType.BRACKET_LEFT.getIdent(), null, (int)2, null), (String)TriggerExpressionConstant.ConstantType.BRACKET_RIGHT.getIdent(), null, (int)2, null);
        if (((CharSequence)token).length() == 0) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{TriggerExpressionConstant.ConstantType.EQUALS.getIdent()};
        List tokens = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.isEmpty() || tokens.size() != 2) {
            return SetsKt.emptySet();
        }
        String identifier = (String)tokens.get(0);
        String value = (String)tokens.get(1);
        Set documents = new LinkedHashSet();
        String string = identifier;
        if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.NAME.getIdent())) {
            Optional<Object> optional = queryToDocIds.keySet().stream().filter(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$2(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$1(value, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
            Optional<Object> key = optional;
            if (key.isPresent()) {
                Set<String> set = queryToDocIds.get(key.get());
                if (set != null) {
                    Set<String> doc = set;
                    boolean bl = false;
                    documents.addAll((Collection)doc);
                }
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.ID.getIdent())) {
            Optional<Object> optional = queryToDocIds.keySet().stream().filter(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$5(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$4(value, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
            Optional<Object> key = optional;
            if (key.isPresent()) {
                Set<String> set = queryToDocIds.get(key.get());
                if (set != null) {
                    Set<String> doc = set;
                    boolean bl = false;
                    documents.addAll((Collection)doc);
                }
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.TAG.getIdent())) {
            queryToDocIds.keySet().stream().forEach(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$9(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$8(value, queryToDocIds, documents, arg_0), arg_0));
        }
        return documents;
    }

    private static final String eqString_delegate$lambda$0(TriggerExpressionRPNResolver this$0) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<ExpressionToken> iterator = this$0.polishNotation.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ExpressionToken> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ExpressionToken expToken;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            ExpressionToken expressionToken = expToken;
            if (expressionToken instanceof TriggerExpressionToken) {
                v1 = stringBuilder.append(((TriggerExpressionToken)expToken).getValue());
            } else if (expressionToken instanceof TriggerExpressionOperator) {
                v1 = stringBuilder.append(((TriggerExpressionOperator)expToken).getValue());
            } else if (expressionToken instanceof TriggerExpressionConstant) {
                v1 = stringBuilder.append(((TriggerExpressionConstant)expToken).getType().getIdent());
            } else {
                throw new Exception();
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static final boolean resolveQueryExpression$lambda$1(String $value, DocLevelQuery it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)$value);
    }

    private static final boolean resolveQueryExpression$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean resolveQueryExpression$lambda$4(String $value, DocLevelQuery it) {
        return Intrinsics.areEqual((Object)it.getId(), (Object)$value);
    }

    private static final boolean resolveQueryExpression$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit resolveQueryExpression$lambda$8(String $value, Map $queryToDocIds, Set $documents, DocLevelQuery it) {
        block1: {
            if (!it.getTags().contains($value)) break block1;
            Set set = (Set)$queryToDocIds.get(it);
            if (set != null) {
                Set it1 = set;
                boolean bl = false;
                $documents.addAll(it1);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void resolveQueryExpression$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TriggerExpressionOperator.values().length];
            try {
                nArray[TriggerExpressionOperator.AND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TriggerExpressionOperator.OR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TriggerExpressionOperator.NOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

