/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestAcknowledgeChainedAlertsActionKt;
import org.opensearch.commons.alerting.action.AcknowledgeChainedAlertRequest;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/resthandler/RestAcknowledgeChainedAlertAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "getAlertIds", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nRestAcknowledgeChainedAlertsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestAcknowledgeChainedAlertsAction.kt\norg/opensearch/alerting/resthandler/RestAcknowledgeChainedAlertAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class RestAcknowledgeChainedAlertAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "acknowledge_chained_alert_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}/_acknowledge/alerts")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestAcknowledgeChainedAlertsActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}/_acknowledge/alerts");
        String workflowId = request.param("workflowID");
        CharSequence charSequence = workflowId;
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32 = false;
            String $i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32 = "Missing workflow id.";
            throw new IllegalArgumentException($i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32.toString());
        }
        XContentParser xContentParser = request.contentParser();
        Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"contentParser(...)");
        List<String> alertIds = this.getAlertIds(xContentParser);
        if (!(!((Collection)alertIds).isEmpty())) {
            boolean bl = false;
            String string = "You must provide at least one alert id.";
            throw new IllegalArgumentException(string.toString());
        }
        AcknowledgeChainedAlertRequest acknowledgeAlertRequest = new AcknowledgeChainedAlertRequest(workflowId, alertIds);
        return arg_0 -> RestAcknowledgeChainedAlertAction.prepareRequest$lambda$2(client, acknowledgeAlertRequest, arg_0);
    }

    private final List<String> getAlertIds(XContentParser xcp) {
        List ids = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!Intrinsics.areEqual((Object)fieldName, (Object)"alerts")) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                String string = xcp.text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                ids.add(string);
            }
        }
        return ids;
    }

    private static final void prepareRequest$lambda$2(NodeClient $client, AcknowledgeChainedAlertRequest $acknowledgeAlertRequest, RestChannel channel) {
        $client.execute(AlertingActions.ACKNOWLEDGE_CHAINED_ALERTS_ACTION_TYPE, (ActionRequest)$acknowledgeAlertRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

