/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.alerting.PPLUtils;
import org.opensearch.alerting.core.ppl.PPLPluginInterface;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.transport.TransportService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/opensearch/alerting/PPLUtils;", "", "<init>", "()V", "evalResultVarRegex", "Lkotlin/text/Regex;", "indicesListRegex", "appendCustomCondition", "", "query", "customCondition", "appendDataRowsLimit", "maxDataRows", "", "executePplQuery", "Lorg/json/JSONObject;", "localNode", "Lorg/opensearch/cluster/node/DiscoveryNode;", "transportService", "Lorg/opensearch/transport/TransportService;", "(Ljava/lang/String;Lorg/opensearch/cluster/node/DiscoveryNode;Lorg/opensearch/transport/TransportService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEvalResultVar", "findEvalResultVarIdxInSchema", "", "customConditionQueryResponse", "evalResultVarName", "getIndicesFromPplQuery", "", "pplQuery", "capPPLQueryResultsSize", "pplQueryResults", "maxSize", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nPPLUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLUtils.kt\norg/opensearch/alerting/PPLUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1563#2:307\n1634#2,3:308\n1869#2,2:311\n*S KotlinDebug\n*F\n+ 1 PPLUtils.kt\norg/opensearch/alerting/PPLUtils\n*L\n230#1:307\n230#1:308,3\n238#1:311,2\n*E\n"})
public final class PPLUtils {
    @NotNull
    public static final PPLUtils INSTANCE = new PPLUtils();
    @NotNull
    private static final Regex evalResultVarRegex = new Regex("\\beval\\s+([a-zA-Z_][a-zA-Z0-9_]*)\\s*=");
    @NotNull
    private static final Regex indicesListRegex = new Regex("(?i)source(?:\\s*)=(?:\\s*)((?:`[^`]+`|[-\\w.*'+]+(?:\\*)?)(?:\\s*,\\s*(?:`[^`]+`|[-\\w.*'+]+\\*?))*)\\s*\\|*");

    private PPLUtils() {
    }

    @NotNull
    public final String appendCustomCondition(@NotNull String query, @NotNull String customCondition) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)customCondition, (String)"customCondition");
        return query + " | " + customCondition;
    }

    @NotNull
    public final String appendDataRowsLimit(@NotNull String query, long maxDataRows) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return query + " | head " + maxDataRows;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executePplQuery(@NotNull String query, @NotNull DiscoveryNode localNode, @NotNull TransportService transportService, @NotNull Continuation<? super JSONObject> $completion) {
        if (!($completion instanceof executePplQuery.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ PPLUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executePplQuery(null, null, null, (Continuation<? super JSONObject>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                transportPplQueryRequest = new TransportPPLQueryRequest(query, new JSONObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)query))), null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)localNode);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)transportService);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)transportPplQueryRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((PPLPluginInterface)PPLPluginInterface.INSTANCE, (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, executePplQuery$lambda$0(org.opensearch.transport.TransportService org.opensearch.cluster.node.DiscoveryNode org.opensearch.sql.plugin.transport.TransportPPLQueryRequest org.opensearch.alerting.core.ppl.PPLPluginInterface org.opensearch.core.action.ActionListener ), (Lorg/opensearch/alerting/core/ppl/PPLPluginInterface;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((TransportService)transportService, (DiscoveryNode)localNode, (TransportPPLQueryRequest)transportPplQueryRequest), (Continuation)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                transportPplQueryRequest = (TransportPPLQueryRequest)$continuation.L$3;
                transportService = (TransportService)$continuation.L$2;
                localNode = (DiscoveryNode)$continuation.L$1;
                query = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                transportPplQueryResponse = (TransportPPLQueryResponse)v0;
                queryResponseJson = new JSONObject(transportPplQueryResponse.getResult());
                return queryResponseJson;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final String findEvalResultVar(@NotNull String customCondition) {
        Intrinsics.checkNotNullParameter((Object)customCondition, (String)"customCondition");
        Object object = Regex.find$default((Regex)evalResultVarRegex, (CharSequence)customCondition, (int)0, (int)2, null);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            throw new IllegalArgumentException("Given custom condition is invalid, could not find eval result variable");
        }
        Object evalResultVar = object;
        return evalResultVar;
    }

    public final int findEvalResultVarIdxInSchema(@NotNull JSONObject customConditionQueryResponse, @NotNull String evalResultVarName) {
        Intrinsics.checkNotNullParameter((Object)customConditionQueryResponse, (String)"customConditionQueryResponse");
        Intrinsics.checkNotNullParameter((Object)evalResultVarName, (String)"evalResultVarName");
        JSONArray schemaList = customConditionQueryResponse.getJSONArray("schema");
        int evalResultVarIdx = -1;
        int n = schemaList.length();
        for (int i = 0; i < n; ++i) {
            JSONObject schemaObj = schemaList.getJSONObject(i);
            String columnName = schemaObj.getString("name");
            if (!Intrinsics.areEqual((Object)columnName, (Object)evalResultVarName)) continue;
            evalResultVarIdx = i;
            break;
        }
        if (evalResultVarIdx == -1) {
            throw new IllegalStateException("Expected to find eval statement results variable \"" + evalResultVarName + "\" in results of PPL query with custom condition, but did not.");
        }
        return evalResultVarIdx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getIndicesFromPplQuery(@NotNull String pplQuery) {
        Collection destination$iv$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)pplQuery, (String)"pplQuery");
        Object object = Regex.find$default((Regex)indicesListRegex, (CharSequence)pplQuery, (int)0, (int)2, null);
        if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
        } else {
            throw new IllegalStateException("Could not find indices that PPL Monitor query searches even after validating the query through SQL/PPL plugin.");
        }
        List indices = (List)destination$iv$iv;
        List unBackTickedIndices = new ArrayList();
        Iterable $this$forEach$iv = indices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"`", (boolean)false, (int)2, null)) {
                String string = it.substring(1, it.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                bl = unBackTickedIndices.add(string);
                continue;
            }
            bl = unBackTickedIndices.add(it);
        }
        return CollectionsKt.toList((Iterable)unBackTickedIndices);
    }

    @NotNull
    public final JSONObject capPPLQueryResultsSize(@NotNull JSONObject pplQueryResults, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)pplQueryResults, (String)"pplQueryResults");
        int pplQueryResultsSize = pplQueryResults.toString().length();
        if ((long)pplQueryResultsSize <= maxSize) {
            return pplQueryResults;
        }
        JSONObject limitExceedMessageQueryResults = new JSONObject();
        JSONArray schema = new JSONArray((Collection)pplQueryResults.getJSONArray("schema").toList());
        JSONArray datarows = new JSONArray().put((Object)new JSONArray((Collection)CollectionsKt.listOf((Object)"The PPL Query results were too large and thus excluded")));
        int total = pplQueryResults.getInt("total");
        int size = pplQueryResults.getInt("size");
        limitExceedMessageQueryResults.put("schema", (Object)schema);
        limitExceedMessageQueryResults.put("datarows", (Object)datarows);
        limitExceedMessageQueryResults.put("total", total);
        limitExceedMessageQueryResults.put("size", size);
        return limitExceedMessageQueryResults;
    }

    private static final Unit executePplQuery$lambda$0(TransportService $transportService, DiscoveryNode $localNode, TransportPPLQueryRequest $transportPplQueryRequest, PPLPluginInterface $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.executeQuery($transportService, $localNode, $transportPplQueryRequest, it);
        return Unit.INSTANCE;
    }
}

