#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-KWuu1liJJ5QAiyXzS0dmTz
key:                  hledger-web-1.43.1-KWuu1liJJ5QAiyXzS0dmTz
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  4e50e97644dc6e269e92ab16c6ffff0f
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-KWuu1liJJ5QAiyXzS0dmTz
depends:
    Decimal-0.5.2-ABXI22eclKG3ehQlap0vnQ
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA base-4.18.2.1
    base64-1.0-3olcispHrL18esRvHVMWOJ
    blaze-html-0.9.2.0-I4ckHDe6bozBFoAkgoLQ0J
    blaze-markup-0.8.3.0-AfTnSqrQPSj6GU0jkIxUwT bytestring-0.11.5.3
    case-insensitive-1.2.1.0-26iNgmqHMOsJk4yniKxDB2
    clientsession-0.9.3.0-AjUl7mgJddYG1NwECKmwsx
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-9Ano6zkKE8Q3t2Yg7Ibwss
    conduit-extra-1.3.8-B6Eb1ypzIORHRjCExezdNC containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    extra-1.7.16-8xfhX7g6qo3J4L1mTio5RX
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-EpV0NuIZ16XAVHfRSsg0LL
    hjsmin-0.2.1-IUXsjOR1d7DLczblQEVNDF
    hledger-1.43.1-C8150O1T22W8osdQ95zv1J
    hledger-lib-1.43.1-66VWsviUDji4vWSGW5vGQe
    hspec-2.11.4-3Oa94i2aSFlFG3qV0JnWlf
    http-client-0.7.19-3gG1vVFkVnQK6P9M9ZTkXM
    http-conduit-2.3.9.1-K1rBhxqbn2TXotaq4g8MV
    http-types-0.12.4-DpLRlhCeIkXGgeQrwJBKkM
    megaparsec-9.7.0-9mft2rSPe2E2MODG5XVe3i mtl-2.3.1
    network-3.1.4.0-Kxe15bkS84aBmhotDoAJWo
    safe-0.3.21-3RMzMcwZ4BJ9WVL6Vifeml
    shakespeare-2.1.7-GxyAnfrMNsO2Rbi0ZzEjQT template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-Isq1lnRC0mk6kwUSQt5zkJ
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    wai-3.2.4-DP7Wq107T9eHDgy7g2zCw
    wai-cors-0.2.7-8L347cAZLwPJwzw2X5CVEt
    wai-extra-3.1.18-HOP6GiGN6Y3H7HQK0MkHft
    wai-handler-launch-3.0.3.1-IJsl2i7NFqhGKDw8IHsVEd
    warp-3.4.0-4jTdxXQfffMAWOOz9ZYhu4
    yaml-0.11.11.2-2uKQ3imTBzRK4XVeM4BHFd
    yesod-1.6.2.1-KM0K7LgnWd1GPzGzTMHeIF
    yesod-core-1.6.27.1-6I0GNp7qReQERdChKXWAuf
    yesod-form-1.7.9-ESKAuXnkc4h49XzBSUQ6g2
    yesod-static-1.6.1.0-2xfftEU5RFqF51dsbmTXwi
    yesod-test-1.6.23-GoPKcvu1uut4SllFc4tYxc

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

