from typing import Any, Dict, Generic, Iterator, List, Optional, Type, TypeVar, Union

from github.ContentFile import ContentFile
from github.GithubObject import GithubObject
from github.Issue import Issue
from github.NamedUser import NamedUser
from github.Requester import Requester

T = TypeVar("T", bound=GithubObject)

class PaginatedListBase(Generic[T]):
    def __getitem__(self, index: Union[int, slice]) -> Any: ...
    def __init__(self) -> None: ...
    def __iter__(self) -> Iterator[T]: ...
    def _grow(self) -> Any: ...
    def _isBiggerThan(self, index: int) -> bool: ...
    class _Slice:
        def __init__(self, theList: PaginatedList[T], theSlice: slice) -> None: ...
        def __iter__(self) -> Iterator[T]: ...
        def __finished(self, index: int) -> bool: ...

class PaginatedList(PaginatedListBase[T]):
    def __init__(
        self,
        contentClass: Type[T],
        requester: Requester,
        firstUrl: str,
        firstParams: Any,
        headers: Optional[Dict[str, str]] = ...,
        list_item: str = ...,
    ) -> None: ...
    def __reverse(self) -> None: ...
    def __parseLinkHeader(self, headers: Dict[str, str]) -> None: ...
    def _couldGrow(self) -> bool: ...
    def _fetchNextPage(self) -> Any: ...
    def _getLastPageUrl(self) -> Optional[str]: ...
    def get_page(self, page: int) -> List[Any]: ...
    @property
    def reversed(self) -> PaginatedList[T]: ...
    @property
    def totalCount(self) -> int: ...
