hmLoadTopic({
hmKeywords:"file masks",
hmTitle:"File Masks",
hmDescription:"A file mask is a pattern of characters and wildcards used to match folder and file names.",
hmPrevLink:"",
hmNextLink:"",
hmParentLink:"index.html",
hmBreadCrumbs:"",
hmTitlePath:"Glossary",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">File Masks<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">A file mask is a pattern of characters and wildcards used to match folder and file names.<\/p>\n\r<p class=\"p_Normal\">Example:  *.* would match any filename.  For historical reasons, it even matches files that don\'t have an extension.<\/p>\n\r<p class=\"p_Normal\">Example:  *.html would match any HTML filename.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Wildcards<\/span><\/p>\n\r<p class=\"p_Normal\">Wildcards allow a file mask to match multiple folder or file names.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0.1875rem 0 0.8750rem 0;\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">?<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches any single character.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">*<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches zero or any other amount of characters.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">[az]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches any single character in the set (a or z).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">[a-z]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches any single character in the range (from a to z).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">[!az]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches any single character not in the set (not a and not z).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">[[]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Matches a single [ character.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Example:  A? would match A followed by any single character.<\/p>\n\r<p class=\"p_Normal\">Example:  A* would match A followed by any amount of characters.<\/p>\n\r<p class=\"p_Normal\">Example:  [a-z0-9] would match any number or letter.<\/p>\n\r<p class=\"p_Normal\">Example:  [!ac-g] would match any character except for a, c, d, e, f, and g.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Simple file masks<\/span><\/p>\n\r<p class=\"p_Normal\">Simple file masks will affect any files or folders whose parent folder is included.  The base folder is always included.  All folders which contain included files are also included.<\/p>\n\r<p class=\"p_Normal\">To exclude rather than include the specified items, add a minus sign (-) in front of a file mask in the <span class=\"f_Command\">Filters<\/span> edit.  In the File Filters dialog, place the file mask in the Exclude edit rather than using the minus sign.<\/p>\n\r<p class=\"p_Normal\">If the last character in the file mask is a period (.) then ? and * wildcards do not match periods to allow filtering of files that don\'t have an extension.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0.1875rem 0 0.8750rem 0;\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">f<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Include any file named f.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">p\\<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Include any folder named p.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">-f<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Exclude any file named f.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">-p\\<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">Exclude any folder named p.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Example:  *.pas;*.dfm;*.dpr would include only files with extensions pas, dfm, or dpr.<\/p>\n\r<p class=\"p_Normal\">Example:  Source\\ would include only folders named Source and their subfolders.<\/p>\n\r<p class=\"p_Normal\">Example:  -*.dcu;-*.ddp would exclude files with extensions dcu, or ddp.<\/p>\n\r<p class=\"p_Normal\">Example:  -Backup\\ would exclude folders named Backup.<\/p>\n\r<p class=\"p_Normal\">Example:  *. would include only files without an extension.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Relative file masks<\/span><\/p>\n\r<p class=\"p_Normal\">Relative file masks affect files or folders in specific locations.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0.1875rem 0 0.8750rem 0;\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">p\\f<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">f must be in folder p.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">.\\f<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">f must be in the base folder.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:3.6250rem; padding:0; border:none\"><p class=\"p_Normal\">...\\f<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">f may have zero or more parent folders.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Example:  Windows\\*.txt would affect any text file in any included folder named Windows.<\/p>\n\r<p class=\"p_Normal\">Example:  ...\\Windows\\*.txt would affect any text file in any folder named Windows.<\/p>\n\r<p class=\"p_Normal\">Example:  .\\Windows\\*.txt would affect any text file in a folder named Windows that is in the base folder.<\/p>\n\r"
})
