hmLoadTopic({
hmKeywords:"scripts,scripts samples",
hmTitle:"Sample Scripts",
hmDescription:"The following are some sample scripts to show how Beyond Compare can use scripts.  You can either use these scripts as is or model your own scripts after them.",
hmPrevLink:"scripts.html",
hmNextLink:"scheduling_a_script.html",
hmParentLink:"scripts.html",
hmBreadCrumbs:"<a href=\"using_bc.html\">Using Beyond Compare<\/a> &gt; <a href=\"scripts.html\">Scripts<\/a>",
hmTitlePath:"Using Beyond Compare > Scripts > Sample Scripts",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Sample Scripts<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">The following are some sample scripts to show how Beyond Compare can use scripts.  You can either use these scripts as is or model your own scripts after them.<\/p>\n\r<p class=\"p_Normal\">Here is a basic script which copies all of the newer and orphaned files from one folder to another, using a previously created session:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;load &quot;<\/span><span class=\"f_CourierFixed\">Sync Laptop<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;sync update:left-&gt;right<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Syncing two folders<\/span><\/p>\n\r<p class=\"p_Normal\">Here is a more advanced script which syncs two specific folders using advanced filters.  This works the same as loading the folders in a Folder Compare session and performing a &quot;Mirror Left to Right&quot; folder synchronization.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Turn logging on.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">log normal &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Log<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Load the default session and exclude all but certain file types.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &lt;default&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;*.html;*.htm;*.png;*.jpg&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Load the base folders.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; ftp:\/\/<\/span><span class=\"f_CourierFixed\">user<\/span><span class=\"f_CourierFixed\">@<\/span><span class=\"f_CourierFixed\">website<\/span><span class=\"f_CourierFixed\">.com\/<\/span><span class=\"f_CourierFixed\">folder<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Copy different files left to right, delete orphans on right.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">sync mirror:left-&gt;right<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Comparing two files by name<\/span><\/p>\n\r<p class=\"p_Normal\">This script compares two files by name.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">file-report layout:side-by-side &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;options:display-mismatches &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;output-to:&quot;%3&quot; &quot;%1&quot; &quot;%2&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">A sample command line, calling the above script:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">BCompare.exe @&quot;<\/span><span class=\"f_CourierFixed\">My Script<\/span><span class=\"f_CourierFixed\">.txt&quot; &quot;<\/span><span class=\"f_CourierFixed\">My File<\/span><span class=\"f_CourierFixed\">.txt&quot; &quot;<\/span><span class=\"f_CourierFixed\">Your File<\/span><span class=\"f_CourierFixed\">.txt&quot; &quot;<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/> <span class=\"f_NotePrompt\">Note<\/span>  An ampersand (&amp;) at the end of a line means that the command continues on the next line.<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/> <span class=\"f_NotePrompt\">Note<\/span>  %1, %2, and %3 refer to the 1st, 2nd and 3rd command line argument, respectively.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Generating a report<\/span><\/p>\n\r<p class=\"p_Normal\">This script compares two files by name and generates an html report showing differences with context:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">text-report layout:side-by-side &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;options:ignore-unimportant,display-context &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;output-to:&quot;%3&quot; output-options:html-color &quot;%1&quot; &quot;%2&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Keeping a web site in sync<\/span><\/p>\n\r<p class=\"p_Normal\">This script keeps a web site in sync with development files.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Turn verbose logging on.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">log verbose append:&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Log<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Set the comparison criteria.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria timestamp size<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Load source and target folders.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; ftp:\/\/<\/span><span class=\"f_CourierFixed\">user<\/span><span class=\"f_CourierFixed\">@<\/span><span class=\"f_CourierFixed\">website<\/span><span class=\"f_CourierFixed\">.com\/<\/span><span class=\"f_CourierFixed\">folder<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Filter to only include source files, ignore CVS subfolders.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;*.htm;*.html;*.php;*.jpg;*.gif;-CVS\\&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Sync the local files to the web site, creating empty folders.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">sync create-empty mirror:left-&gt;right<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Performing a rules-based comparison and logging results to a file<\/span><\/p>\n\r<p class=\"p_Normal\">This script logs the script results to a file that uses the current date as part of the name.  The variable %date% is expanded by the script in the format 2012-12-31 on U.S. English systems, on other systems it will match the system locale.  It performs a rules-based comparison of Pascal source files and generates a report of mismatches.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Log to a file of the form &quot;C:\\My Log 2012-12-31.txt&quot;.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># The exact format depends on your regional and language settings.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">log verbose append:&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Log<\/span><span class=\"f_CourierFixed\"> %date%.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Compare the text contents of the files.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria rules-based<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Only compare Delphi source files, ignore the archive folder.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;*.pas;*.dfm;*.dpr;*.inc;-archive\\&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; &quot;C:\\<\/span><span class=\"f_CourierFixed\">Your Folder<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">folder-report layout:summary &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;options:display-mismatches,column-attributes,column-timestamp,column-size &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp;output-to:&quot;<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Comparing current folder state to a snapshot<\/span><\/p>\n\r<p class=\"p_Normal\">This script compares the current state of a folder to a snapshot from the last time updates were sent out.  Then it copies the changed and new files to an archive file and updates the snapshot of the folder.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">option confirm:yes-to-all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Compare using crc.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria crc<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Load current files against snapshot from the last patch.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Snapshot<\/span><span class=\"f_CourierFixed\">.bcss&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Expand to affect subfolders and files.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">expand all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Select updated files.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select left.diff.files left.orphan.files<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Copy changes to an archive file.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">copyto left path:relative &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Archive<\/span><span class=\"f_CourierFixed\">.zip&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Update the snapshot.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">snapshot save-crc left output:&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Snapshot<\/span><span class=\"f_CourierFixed\">.bcss&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Generating a report of differences<\/span><\/p>\n\r<p class=\"p_Normal\">This script generates a report of only differences.<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Set up basic comparison features.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria timestamp:2sec<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Filter out log files.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;-*.log&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Load first comparison.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; &quot;C:\\<\/span><span class=\"f_CourierFixed\">Your Folder<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Compare files with timestamp differences.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select newer.files older.files<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"># Generate a report of the differences.<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">folder-report layout:summary options:display-mismatches output-to:&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r"
})
